package io.datalbry.jira.cloud.client.feign.board

import feign.Param
import feign.RequestLine
import io.datalbry.jira.cloud.client.model.*
import io.datalbry.jira.cloud.client.pagination.PaginatedIssues
import io.datalbry.jira.cloud.client.pagination.PaginatedValues

interface FeignBoardResource {

    @RequestLine("GET /rest/agile/1.0/board/{boardId}")
    fun getBoard(
        @Param("boardId") boardKey: Int
    ): Board

    @RequestLine("GET /rest/agile/1.0/board${KEY_QUERY}")
    fun getBoardKeys(
        @Param("maxResults") limit: Int,
        @Param("startAt") start: Int
    ): PaginatedValues<BoardKey>

    @RequestLine("GET /rest/agile/1.0/board/{boardId}/configuration")
    fun getConfiguration(
        @Param("boardId") boardKey: Int
    ): Configuration

    @RequestLine("GET /rest/agile/1.0/board/{boardId}/issue${KEY_QUERY}")
    fun getIssueKeys(
        @Param("boardId") boardKey: Int,
        @Param("maxResults") limit: Int,
        @Param("startAt") start: Int
    ): PaginatedIssues<IssueKey>

    @RequestLine("GET /rest/agile/1.0/issue/{issueId}")
    fun getIssue(
        @Param("issueId") IssueKey: String
    ): Issue

    @RequestLine("GET /rest/agile/1.0/board/{boardId}/features")
    fun getFeatures(
        @Param("boardId") boardKey: Int,
    ): Features

    @RequestLine("GET /rest/agile/1.0/board/{boardId}/quickfilter${KEY_QUERY}")
    fun getQuickfilterKeys(
        @Param("boardId") boardKey: Int,
        @Param("maxResults") limit: Int,
        @Param("startAt") start: Int
    ): PaginatedValues<QuickfilterKey>

    @RequestLine("GET /rest/agile/1.0/board/{boardId}/quickfilter/{quickfilterId}")
    fun getQuickfilter(
        @Param("boardId") boardKey: Int,
        @Param("quickfilterId") quickfilterId: Int,
    ): Quickfilter

    @RequestLine("GET /rest/agile/1.0/board/{boardId}/version${KEY_QUERY}")
    fun getVersions(
        @Param("boardId") boardKey: Int,
        @Param("maxResults") limit: Int,
        @Param("startAt") start: Int
    ): PaginatedValues<Version>

    @RequestLine("GET /rest/agile/1.0/board/{boardId}/reports")
    fun getReports(
        @Param("boardId") boardKey: Int,
    ): Reports

    @RequestLine("GET /rest/agile/1.0/board/{boardId}/sprint${KEY_QUERY}")
    fun getSprintsKeys(
        @Param("boardId") boardKey: Int,
        @Param("maxResults") limit: Int,
        @Param("startAt") start: Int
    ): PaginatedValues<SprintKey>

    @RequestLine("GET /rest/agile/1.0/sprint/{sprintId}")
    fun getSprint(
        @Param("sprintId") sprintId: Int,
    ): Sprint

    @RequestLine("GET /rest/agile/1.0/board/{boardId}/epic${KEY_QUERY}")
    fun getEpicKeys(
        @Param("boardId") boardKey: Int,
        @Param("maxResults") limit: Int,
        @Param("startAt") start: Int
    ): PaginatedValues<EpicKey>

    @RequestLine("GET /rest/agile/1.0/epic/{epicId}")
    fun getEpic(
        @Param("epicId") epicId: Int,
    ): Epic

    @RequestLine("GET /rest/agile/1.0/board/{boardId}/project${KEY_QUERY}")
    fun getProjects(
        @Param("boardId") boardKey: Int,
        @Param("maxResults") limit: Int,
        @Param("startAt") start: Int
    ): PaginatedValues<Project>

    companion object {
        const val KEY_QUERY: String = "?maxResults={maxResults}&startAt={startAt}"
    }
}
