/*
 * Decompiled with CFR 0.152.
 */
package io.datalbry.connector.autoconfigure.jms;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import io.datalbry.connector.autoconfigure.jms.MessageConsumerAutoConfiguration;
import io.datalbry.connector.sdk.consumer.AdditionMessageConsumer;
import io.datalbry.connector.sdk.consumer.DeletionMessageConsumer;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.support.converter.MappingJackson2MessageConverter;
import org.springframework.jms.support.converter.MessageType;

@Configuration
@ConditionalOnClass(value={AdditionMessageConsumer.class, DeletionMessageConsumer.class})
@AutoConfigureAfter(value={MessageConsumerAutoConfiguration.class})
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017\u00a8\u0006\u0005"}, d2={"Lio/datalbry/connector/autoconfigure/jms/JmsAutoConfiguration;", "", "()V", "jacksonMessageConverter", "Lorg/springframework/jms/support/converter/MappingJackson2MessageConverter;", "sdk-autoconfigure"})
public class JmsAutoConfiguration {
    @Bean
    @NotNull
    public MappingJackson2MessageConverter jacksonMessageConverter() {
        ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
        MappingJackson2MessageConverter converter = new MappingJackson2MessageConverter();
        converter.setObjectMapper(mapper);
        converter.setTargetType(MessageType.TEXT);
        converter.setTypeIdPropertyName("type");
        return converter;
    }
}

