/*
 * Decompiled with CFR 0.152.
 */
package io.datalbry.connector.sdk.messaging.jms;

import io.datalbry.connector.api.DocumentEdge;
import io.datalbry.connector.sdk.messaging.Channel;
import io.datalbry.connector.sdk.messaging.jms.JmsAddChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jms.core.BrowserCallback;
import org.springframework.jms.core.JmsTemplate;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u001e\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/datalbry/connector/sdk/messaging/jms/JmsAddChannel;", "Lio/datalbry/connector/sdk/messaging/Channel;", "Lio/datalbry/connector/api/DocumentEdge;", "jmsTemplate", "Lorg/springframework/jms/core/JmsTemplate;", "(Lorg/springframework/jms/core/JmsTemplate;)V", "datasourceKey", "", "getDatasourceKey", "()Ljava/lang/String;", "setDatasourceKey", "(Ljava/lang/String;)V", "hasElement", "", "propagate", "", "message", "sdk"})
public final class JmsAddChannel
implements Channel<DocumentEdge> {
    @Value(value="${io.datalbry.datasource.key}")
    public String datasourceKey;
    private final JmsTemplate jmsTemplate;

    @NotNull
    public final String getDatasourceKey() {
        String string = this.datasourceKey;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"datasourceKey");
        }
        return string;
    }

    public final void setDatasourceKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.datasourceKey = string;
    }

    @Override
    public void propagate(@NotNull DocumentEdge message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Map headers = MapsKt.toMutableMap((Map)message.getHeaders());
        headers.put("_type", String.valueOf(Reflection.getOrCreateKotlinClass(DocumentEdge.class).getQualifiedName()));
        DocumentEdge enrichedMessage = DocumentEdge.copy$default((DocumentEdge)message, null, (Map)headers, null, (int)5, null);
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.datasourceKey;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"datasourceKey");
        }
        this.jmsTemplate.convertAndSend(stringBuilder.append(string).append("-document_addition").toString(), (Object)enrichedMessage);
    }

    @Override
    public boolean hasElement() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.datasourceKey;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"datasourceKey");
        }
        Boolean bl = (Boolean)this.jmsTemplate.browse(stringBuilder.append(string).append("-document_addition").toString(), (BrowserCallback)hasElement.1.INSTANCE);
        return bl != null ? bl : false;
    }

    public JmsAddChannel(@NotNull JmsTemplate jmsTemplate) {
        Intrinsics.checkNotNullParameter((Object)jmsTemplate, (String)"jmsTemplate");
        this.jmsTemplate = jmsTemplate;
    }
}

