/*
 * Decompiled with CFR 0.152.
 */
package io.datalbry.connector.sdk.state.jpa;

import io.datalbry.connector.sdk.state.ConnectorDocumentState;
import io.datalbry.connector.sdk.state.DocumentState;
import io.datalbry.connector.sdk.state.Lock;
import io.datalbry.connector.sdk.state.LockException;
import io.datalbry.connector.sdk.state.NodeReference;
import io.datalbry.connector.sdk.state.jpa.DocumentRepository;
import io.datalbry.connector.sdk.state.jpa.JobRepository;
import io.datalbry.connector.sdk.state.jpa.LockRepository;
import io.datalbry.connector.sdk.state.jpa.entity.DocumentRelationshipEntity;
import io.datalbry.connector.sdk.state.jpa.entity.LockEntity;
import io.datalbry.connector.sdk.state.jpa.entity.NodeRelationshipEntity;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\fH\u0017J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J \u0010\u001a\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J \u0010\u001a\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J1\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/datalbry/connector/sdk/state/jpa/JpaConnectorDocumentState;", "Lio/datalbry/connector/sdk/state/ConnectorDocumentState;", "jobRepository", "Lio/datalbry/connector/sdk/state/jpa/JobRepository;", "documentRepository", "Lio/datalbry/connector/sdk/state/jpa/DocumentRepository;", "lockRepository", "Lio/datalbry/connector/sdk/state/jpa/LockRepository;", "(Lio/datalbry/connector/sdk/state/jpa/JobRepository;Lio/datalbry/connector/sdk/state/jpa/DocumentRepository;Lio/datalbry/connector/sdk/state/jpa/LockRepository;)V", "getChecksum", "", "parent", "Lio/datalbry/connector/sdk/state/NodeReference;", "docId", "lock", "Lio/datalbry/connector/sdk/state/Lock;", "getUnseenDocuments", "", "node", "getUnseenNodes", "put", "", "doc", "Lio/datalbry/connector/sdk/state/DocumentState;", "child", "release", "remove", "runIfLocked", "T", "runnable", "Lkotlin/Function0;", "(Lio/datalbry/connector/sdk/state/NodeReference;Lio/datalbry/connector/sdk/state/Lock;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "sdk"})
public class JpaConnectorDocumentState
implements ConnectorDocumentState {
    private final JobRepository jobRepository;
    private final DocumentRepository documentRepository;
    private final LockRepository lockRepository;

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    @NotNull
    public Lock lock(@NotNull NodeReference node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!this.lockRepository.existsByNode(node.getUuid())) {
            UUID uUID = node.getUuid();
            UUID uUID2 = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"UUID.randomUUID()");
            ZonedDateTime zonedDateTime = ZonedDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ZonedDateTime.now()");
            LockEntity entity = new LockEntity(uUID, uUID2, zonedDateTime);
            this.lockRepository.save(entity);
            return new Lock(entity.getUuid());
        }
        throw (Throwable)new LockException("Job[" + node.getUuid() + "] is already being locked.");
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void put(@NotNull NodeReference parent, @NotNull NodeReference child, @NotNull Lock lock) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        this.runIfLocked(parent, lock, (Function0)new Function0<Unit>(this, parent, child, lock){
            final /* synthetic */ JpaConnectorDocumentState this$0;
            final /* synthetic */ NodeReference $parent;
            final /* synthetic */ NodeReference $child;
            final /* synthetic */ Lock $lock;

            public void invoke() {
                NodeRelationshipEntity entity = new NodeRelationshipEntity(this.$parent.getUuid(), this.$child.getUuid(), this.$lock.getUuid());
                JpaConnectorDocumentState.access$getJobRepository$p(this.this$0).save(entity);
            }
            {
                this.this$0 = jpaConnectorDocumentState;
                this.$parent = nodeReference;
                this.$child = nodeReference2;
                this.$lock = lock;
                super(0);
            }
        });
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void put(@NotNull NodeReference parent, @NotNull DocumentState doc, @NotNull Lock lock) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        this.runIfLocked(parent, lock, (Function0)new Function0<Unit>(this, parent, doc, lock){
            final /* synthetic */ JpaConnectorDocumentState this$0;
            final /* synthetic */ NodeReference $parent;
            final /* synthetic */ DocumentState $doc;
            final /* synthetic */ Lock $lock;

            public void invoke() {
                DocumentRelationshipEntity entity = new DocumentRelationshipEntity(this.$parent.getUuid(), this.$doc.getId(), this.$doc.getChecksum(), this.$lock.getUuid());
                JpaConnectorDocumentState.access$getDocumentRepository$p(this.this$0).save(entity);
            }
            {
                this.this$0 = jpaConnectorDocumentState;
                this.$parent = nodeReference;
                this.$doc = documentState;
                this.$lock = lock;
                super(0);
            }
        });
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void remove(@NotNull NodeReference parent, @NotNull String docId, @NotNull Lock lock) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)docId, (String)"docId");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        this.runIfLocked(parent, lock, (Function0)new Function0<Unit>(this, parent, docId){
            final /* synthetic */ JpaConnectorDocumentState this$0;
            final /* synthetic */ NodeReference $parent;
            final /* synthetic */ String $docId;

            public void invoke() {
                JpaConnectorDocumentState.access$getDocumentRepository$p(this.this$0).removeByNodeAndDocumentKey(this.$parent.getUuid(), this.$docId);
            }
            {
                this.this$0 = jpaConnectorDocumentState;
                this.$parent = nodeReference;
                this.$docId = string;
                super(0);
            }
        });
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void remove(@NotNull NodeReference parent, @NotNull NodeReference child, @NotNull Lock lock) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        this.runIfLocked(parent, lock, (Function0)new Function0<Unit>(this, parent, child){
            final /* synthetic */ JpaConnectorDocumentState this$0;
            final /* synthetic */ NodeReference $parent;
            final /* synthetic */ NodeReference $child;

            public void invoke() {
                JpaConnectorDocumentState.access$getJobRepository$p(this.this$0).removeByParentAndChild(this.$parent.getUuid(), this.$child.getUuid());
            }
            {
                this.this$0 = jpaConnectorDocumentState;
                this.$parent = nodeReference;
                this.$child = nodeReference2;
                super(0);
            }
        });
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void remove(@NotNull NodeReference node, @NotNull Lock lock) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        this.runIfLocked(node, lock, (Function0)new Function0<Unit>(this, node){
            final /* synthetic */ JpaConnectorDocumentState this$0;
            final /* synthetic */ NodeReference $node;

            public void invoke() {
                JpaConnectorDocumentState.access$getDocumentRepository$p(this.this$0).removeByNode(this.$node.getUuid());
                JpaConnectorDocumentState.access$getJobRepository$p(this.this$0).removeByParent(this.$node.getUuid());
            }
            {
                this.this$0 = jpaConnectorDocumentState;
                this.$node = nodeReference;
                super(0);
            }
        });
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    @NotNull
    public String getChecksum(@NotNull NodeReference parent, @NotNull String docId, @NotNull Lock lock) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)docId, (String)"docId");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        return (String)this.runIfLocked(parent, lock, (Function0)new Function0<String>(this, parent, docId){
            final /* synthetic */ JpaConnectorDocumentState this$0;
            final /* synthetic */ NodeReference $parent;
            final /* synthetic */ String $docId;

            @NotNull
            public String invoke() {
                Object object = JpaConnectorDocumentState.access$getDocumentRepository$p(this.this$0).getByNodeAndDocumentKey(this.$parent.getUuid(), this.$docId);
                if (object == null || (object = ((DocumentRelationshipEntity)object).getDocumentChecksum()) == null) {
                    object = "";
                }
                return object;
            }
            {
                this.this$0 = jpaConnectorDocumentState;
                this.$parent = nodeReference;
                this.$docId = string;
                super(0);
            }
        });
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    @NotNull
    public Collection<NodeReference> getUnseenNodes(@NotNull NodeReference node, @NotNull Lock lock) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        return (Collection)this.runIfLocked(node, lock, (Function0)new Function0<List<? extends NodeReference>>(this, node, lock){
            final /* synthetic */ JpaConnectorDocumentState this$0;
            final /* synthetic */ NodeReference $node;
            final /* synthetic */ Lock $lock;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<NodeReference> invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = JpaConnectorDocumentState.access$getJobRepository$p(this.this$0).findAllByParentAndRevisionIsNot(this.$node.getUuid(), this.$lock.getUuid());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    NodeRelationshipEntity nodeRelationshipEntity = (NodeRelationshipEntity)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    NodeReference nodeReference = new NodeReference(it.getChild());
                    collection.add(nodeReference);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = jpaConnectorDocumentState;
                this.$node = nodeReference;
                this.$lock = lock;
                super(0);
            }
        });
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    @NotNull
    public Collection<String> getUnseenDocuments(@NotNull NodeReference node, @NotNull Lock lock) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        return (Collection)this.runIfLocked(node, lock, (Function0)new Function0<List<? extends String>>(this, node, lock){
            final /* synthetic */ JpaConnectorDocumentState this$0;
            final /* synthetic */ NodeReference $node;
            final /* synthetic */ Lock $lock;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<String> invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = JpaConnectorDocumentState.access$getDocumentRepository$p(this.this$0).findAllByNodeAndRevisionIsNot(this.$node.getUuid(), this.$lock.getUuid());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    DocumentRelationshipEntity documentRelationshipEntity = (DocumentRelationshipEntity)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getDocumentKey();
                    collection.add(string);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = jpaConnectorDocumentState;
                this.$node = nodeReference;
                this.$lock = lock;
                super(0);
            }
        });
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void release(@NotNull NodeReference node, @NotNull Lock lock) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        this.runIfLocked(node, lock, (Function0)new Function0<Unit>(this, node, lock){
            final /* synthetic */ JpaConnectorDocumentState this$0;
            final /* synthetic */ NodeReference $node;
            final /* synthetic */ Lock $lock;

            public void invoke() {
                JpaConnectorDocumentState.access$getLockRepository$p(this.this$0).deleteByNodeAndUuid(this.$node.getUuid(), this.$lock.getUuid());
            }
            {
                this.this$0 = jpaConnectorDocumentState;
                this.$node = nodeReference;
                this.$lock = lock;
                super(0);
            }
        });
    }

    private final <T> T runIfLocked(NodeReference parent, Lock lock, Function0<? extends T> runnable) {
        if (this.lockRepository.existsByNodeAndUuid(parent.getUuid(), lock.getUuid())) {
            return (T)runnable.invoke();
        }
        throw (Throwable)new LockException("Job[" + parent.getUuid() + "] is not being locked by Lock[" + lock.getUuid() + "].");
    }

    public JpaConnectorDocumentState(@NotNull JobRepository jobRepository, @NotNull DocumentRepository documentRepository, @NotNull LockRepository lockRepository) {
        Intrinsics.checkNotNullParameter((Object)jobRepository, (String)"jobRepository");
        Intrinsics.checkNotNullParameter((Object)documentRepository, (String)"documentRepository");
        Intrinsics.checkNotNullParameter((Object)lockRepository, (String)"lockRepository");
        this.jobRepository = jobRepository;
        this.documentRepository = documentRepository;
        this.lockRepository = lockRepository;
    }

    public static final /* synthetic */ JobRepository access$getJobRepository$p(JpaConnectorDocumentState $this) {
        return $this.jobRepository;
    }

    public static final /* synthetic */ DocumentRepository access$getDocumentRepository$p(JpaConnectorDocumentState $this) {
        return $this.documentRepository;
    }

    public static final /* synthetic */ LockRepository access$getLockRepository$p(JpaConnectorDocumentState $this) {
        return $this.lockRepository;
    }
}

