/*
 * Decompiled with CFR 0.152.
 */
package io.datalbry.connector.sdk.test;

import io.datalbry.connector.sdk.test.ConnectorTestExtensionKt;
import io.datalbry.connector.sdk.test.container.PostgresContainer;
import io.datalbry.testcontainers.bigtable.AlxndriaContainer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/datalbry/connector/sdk/test/ConnectorTestExtension;", "Lorg/junit/jupiter/api/extension/BeforeAllCallback;", "Lorg/junit/jupiter/api/extension/AfterAllCallback;", "()V", "alxndria", "Lio/datalbry/testcontainers/bigtable/AlxndriaContainer;", "postgres", "Lio/datalbry/connector/sdk/test/container/PostgresContainer;", "afterAll", "", "context", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "beforeAll", "getAlxndriaVersion", "", "getPostgresVersion", "Companion", "sdk-test"})
public final class ConnectorTestExtension
implements BeforeAllCallback,
AfterAllCallback {
    private final AlxndriaContainer alxndria = new AlxndriaContainer(this.getAlxndriaVersion(), 0, 2, null);
    private final PostgresContainer postgres = new PostgresContainer(this.getPostgresVersion());
    @NotNull
    public static final String TEST_DATASOURCE = "test";
    @NotNull
    public static final String PROPERTY_DATALBRY_PLATFORM_URI = "io.datalbry.connector.alxndria.uri";
    @NotNull
    public static final String PROPERTY_SPRING_DATASOURCE_URL = "spring.datasource.url";
    @NotNull
    public static final String PROPERTY_SPRING_DATASOURCE_USERNAME = "spring.datasource.username";
    @NotNull
    public static final String PROPERTY_SPRING_DATASOURCE_PASSWORD = "spring.datasource.password";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void beforeAll(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.alxndria.start();
        this.postgres.start();
        System.setProperty(PROPERTY_DATALBRY_PLATFORM_URI, "http://127.0.0.1:" + this.alxndria.getPort());
        System.setProperty("io.datalbry.connector.alxndria.datasource", TEST_DATASOURCE);
        System.setProperty("spring.jpa.hibernate.ddl-auto", "create");
        System.setProperty(PROPERTY_SPRING_DATASOURCE_URL, this.postgres.getJdbcUrl());
        System.setProperty(PROPERTY_SPRING_DATASOURCE_USERNAME, this.postgres.getUsername());
        System.setProperty(PROPERTY_SPRING_DATASOURCE_PASSWORD, this.postgres.getPassword());
    }

    public void afterAll(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.postgres.stop();
        this.alxndria.stop();
    }

    private final String getPostgresVersion() {
        return ConnectorTestExtensionKt.access$getEnvOrDefault("test.postgres.container.version", "9.6.12");
    }

    private final String getAlxndriaVersion() {
        return ConnectorTestExtensionKt.access$getEnvOrDefault("test.alxndria.container.version", "0.0.3-SNAPSHOT");
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/datalbry/connector/sdk/test/ConnectorTestExtension$Companion;", "", "()V", "PROPERTY_DATALBRY_PLATFORM_URI", "", "PROPERTY_SPRING_DATASOURCE_PASSWORD", "PROPERTY_SPRING_DATASOURCE_URL", "PROPERTY_SPRING_DATASOURCE_USERNAME", "TEST_DATASOURCE", "sdk-test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

