/*
 * Decompiled with CFR 0.152.
 */
package io.datalbry.connector.plugin.task;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import io.datalbry.connector.plugin.ConnectorPluginExtension;
import io.datalbry.connector.plugin.extensions.ConnectorRegistryExtension;
import io.datalbry.connector.plugin.extensions.ContainerExtension;
import io.datalbry.connector.plugin.extensions.OidcExtension;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.kotlin.util.UtilKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0007J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/datalbry/connector/plugin/task/RegisterConnectorTask;", "Lorg/gradle/api/DefaultTask;", "()V", "http", "Lorg/apache/http/impl/client/CloseableHttpClient;", "kotlin.jvm.PlatformType", "json", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "buildConnectorJson", "", "fetchOidcToken", "isSnapshotRelease", "", "extension", "Lio/datalbry/connector/plugin/ConnectorPluginExtension;", "postConnectorToRegistry", "", "connectorJson", "accessToken", "publish", "snapshotEnabled", "registry", "Lio/datalbry/connector/plugin/extensions/ConnectorRegistryExtension;", "createFormEntity", "Lorg/apache/http/client/entity/UrlEncodedFormEntity;", "Lio/datalbry/connector/plugin/extensions/OidcExtension;", "sdk-plugin"})
public class RegisterConnectorTask
extends DefaultTask {
    private final ObjectMapper json = ExtensionsKt.jacksonObjectMapper();
    private final CloseableHttpClient http = HttpClientBuilder.create().build();

    @TaskAction
    public final void publish() {
        String connectorJson = this.buildConnectorJson();
        String accessToken = this.fetchOidcToken();
        this.postConnectorToRegistry(connectorJson, accessToken);
    }

    private final void postConnectorToRegistry(String connectorJson, String accessToken) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Object object = project.getExtensions().getByType(ConnectorPluginExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.getBy\u2026ginExtension::class.java)");
        ConnectorPluginExtension extension = (ConnectorPluginExtension)object;
        ConnectorRegistryExtension registry = extension.getRegistry();
        String baseUrl = UtilKt.prefixBaseNameIfNot((String)registry.getBaseUrl(), (String)"https://");
        String requestUrl = baseUrl + "/connector/registry";
        if (this.snapshotEnabled(registry) && this.isSnapshotRelease(extension)) {
            requestUrl = requestUrl + "$namespace=snapshot";
        }
        HttpPost post = new HttpPost(requestUrl);
        post.addHeader("Content-Type", "application/json");
        post.addHeader("Authorization", "Bearer " + accessToken);
        post.setEntity((HttpEntity)new StringEntity(connectorJson));
        this.http.execute((HttpUriRequest)post);
    }

    private final boolean snapshotEnabled(ConnectorRegistryExtension registry) {
        return registry.getSnapshotReleaseEnabled();
    }

    private final boolean isSnapshotRelease(ConnectorPluginExtension extension) {
        String string = extension.getVersion();
        Intrinsics.checkNotNull((Object)string);
        return StringsKt.endsWith$default((String)string, (String)"-SNAPSHOT", (boolean)false, (int)2, null);
    }

    private final String buildConnectorJson() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Object object = project.getExtensions().getByType(ConnectorPluginExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.getBy\u2026ginExtension::class.java)");
        ConnectorPluginExtension extension = (ConnectorPluginExtension)object;
        ContainerExtension container = extension.getContainer();
        StringBuilder stringBuilder = new StringBuilder();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        File file = project2.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
        File docSchemaFile = new File(stringBuilder.append(file.getAbsolutePath()).append('/').append(extension.getDocumentSchemaPath()).toString());
        StringBuilder stringBuilder2 = new StringBuilder();
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        File file2 = project3.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.buildDir");
        File configSchemaFile = new File(stringBuilder2.append(file2.getAbsolutePath()).append('/').append(extension.getConfigSchemaPath()).toString());
        ObjectNode root = this.json.getNodeFactory().objectNode();
        ObjectNode id = this.json.getNodeFactory().objectNode();
        id.put("name", extension.getName());
        id.put("version", extension.getVersion());
        root.set("id", (JsonNode)id);
        root.set("docSchema", ExtensionsKt.jacksonObjectMapper().readTree(docSchemaFile));
        root.set("configSchema", ExtensionsKt.jacksonObjectMapper().readTree(configSchemaFile));
        root.put("image", container.getRepository() + '/' + extension.getName() + ':' + extension.getVersion());
        String string = this.json.writeValueAsString((Object)root);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.writeValueAsString(root)");
        return string;
    }

    private final String fetchOidcToken() {
        CloseableHttpResponse response;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Object object = project.getExtensions().getByType(ConnectorPluginExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.getBy\u2026ginExtension::class.java)");
        ConnectorPluginExtension extension = (ConnectorPluginExtension)object;
        OidcExtension oidc = extension.getOidc();
        String baseUrl = UtilKt.prefixBaseNameIfNot((String)oidc.getBaseUrl(), (String)"https://");
        String requestUrl = baseUrl + "/auth/realms/" + oidc.getRealm() + "/protocol/openid-connect/token";
        HttpPost post = new HttpPost(requestUrl);
        post.addHeader("Content-Type", "application/x-www-form-urlencoded");
        post.setEntity((HttpEntity)this.createFormEntity(oidc));
        CloseableHttpResponse closeableHttpResponse = response = this.http.execute((HttpUriRequest)post);
        Intrinsics.checkNotNullExpressionValue((Object)closeableHttpResponse, (String)"response");
        String jsonResponse = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
        String string = this.json.readTree(jsonResponse).get("access_token").asText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.readTree(jsonRespon\u2026(\"access_token\").asText()");
        return string;
    }

    private final UrlEncodedFormEntity createFormEntity(OidcExtension $this$createFormEntity) {
        Object[] objectArray = new BasicNameValuePair[5];
        String string = $this$createFormEntity.getUsername();
        Intrinsics.checkNotNull((Object)string);
        objectArray[0] = new BasicNameValuePair("username", string);
        String string2 = $this$createFormEntity.getPassword();
        Intrinsics.checkNotNull((Object)string2);
        objectArray[1] = new BasicNameValuePair("password", string2);
        objectArray[2] = new BasicNameValuePair("grant_type", "password");
        objectArray[3] = new BasicNameValuePair("client_id", $this$createFormEntity.getClientId());
        String string3 = $this$createFormEntity.getClientSecret();
        Intrinsics.checkNotNull((Object)string3);
        objectArray[4] = new BasicNameValuePair("client_secret", string3);
        List formValues = CollectionsKt.listOf((Object[])objectArray);
        return new UrlEncodedFormEntity(formValues, "UTF-8");
    }

    public RegisterConnectorTask() {
        Task task = this.getProject().task("compile");
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"project.task(\"compile\")");
        Task compileTask = task;
        this.dependsOn(new Object[]{compileTask});
    }
}

