/*
 * Decompiled with CFR 0.152.
 */
package io.datalbry.connector.autoconfigure.amqp;

import io.datalbry.connector.autoconfigure.consumer.MessageConsumerAutoConfiguration;
import io.datalbry.connector.sdk.consumer.AdditionMessageConsumer;
import io.datalbry.connector.sdk.consumer.DeletionMessageConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={AdditionMessageConsumer.class, DeletionMessageConsumer.class})
@AutoConfigureBefore(value={MessageConsumerAutoConfiguration.class})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u000e\u001a\u00020\u000fH\u0017J\b\u0010\u0010\u001a\u00020\u0011H\u0017J\b\u0010\u0012\u001a\u00020\rH\u0017J\b\u0010\u0013\u001a\u00020\u000fH\u0017J\b\u0010\u0014\u001a\u00020\u0011H\u0017R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\u0015"}, d2={"Lio/datalbry/connector/autoconfigure/amqp/RabbitAutoConfiguration;", "", "()V", "additionMessageChannel", "", "getAdditionMessageChannel", "()Ljava/lang/String;", "setAdditionMessageChannel", "(Ljava/lang/String;)V", "deletionMessageChannel", "getDeletionMessageChannel", "setDeletionMessageChannel", "additionQueue", "Lorg/springframework/amqp/core/Queue;", "additionQueueBinding", "Lorg/springframework/amqp/core/Binding;", "additionTopicExchange", "Lorg/springframework/amqp/core/TopicExchange;", "deletionQueue", "deletionQueueBinding", "deletionTopicExchange", "sdk-autoconfigure"})
public class RabbitAutoConfiguration {
    @Value(value="${io.datalbry.connector.alxndria.datasource}-document_addition")
    public String additionMessageChannel;
    @Value(value="${io.datalbry.connector.alxndria.datasource}-document_deletion")
    public String deletionMessageChannel;

    @NotNull
    public String getAdditionMessageChannel() {
        String string = this.additionMessageChannel;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"additionMessageChannel");
        }
        return string;
    }

    public void setAdditionMessageChannel(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.additionMessageChannel = string;
    }

    @NotNull
    public String getDeletionMessageChannel() {
        String string = this.deletionMessageChannel;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deletionMessageChannel");
        }
        return string;
    }

    public void setDeletionMessageChannel(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.deletionMessageChannel = string;
    }

    @Bean
    @NotNull
    public Queue additionQueue() {
        return new Queue(this.getAdditionMessageChannel(), true);
    }

    @Bean
    @NotNull
    public Queue deletionQueue() {
        return new Queue(this.getDeletionMessageChannel(), true);
    }

    @Bean
    @NotNull
    public TopicExchange additionTopicExchange() {
        return new TopicExchange("document_addition");
    }

    @Bean
    @NotNull
    public TopicExchange deletionTopicExchange() {
        return new TopicExchange("document_deletion");
    }

    @Bean
    @NotNull
    public Binding additionQueueBinding() {
        Binding binding = BindingBuilder.bind((Queue)this.additionQueue()).to(this.additionTopicExchange()).with("document_addition");
        Intrinsics.checkNotNull((Object)binding);
        return binding;
    }

    @Bean
    @NotNull
    public Binding deletionQueueBinding() {
        Binding binding = BindingBuilder.bind((Queue)this.additionQueue()).to(this.additionTopicExchange()).with("document_deletion");
        Intrinsics.checkNotNull((Object)binding);
        return binding;
    }
}

