/*
 * Decompiled with CFR 0.152.
 */
package io.datalbry.connector.autoconfigure;

import io.datalbry.alxndria.client.api.DatasourceClient;
import io.datalbry.alxndria.client.api.IndexClient;
import io.datalbry.alxndria.client.api.PlatformClient;
import io.datalbry.alxndria.client.feign.v1.FeignPlatformClient;
import io.datalbry.connector.sdk.ConnectorProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ConnectorProperties.class})
@ConditionalOnClass(value={ConnectorProperties.class, FeignPlatformClient.class})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u000b"}, d2={"Lio/datalbry/connector/autoconfigure/FeignPlatformClientAutoConfiguration;", "", "()V", "feignDatasourceClient", "Lio/datalbry/alxndria/client/api/DatasourceClient;", "properties", "Lio/datalbry/connector/sdk/ConnectorProperties;", "feignIndexClient", "Lio/datalbry/alxndria/client/api/IndexClient;", "feignPlatformClient", "Lio/datalbry/alxndria/client/feign/v1/FeignPlatformClient;", "sdk-autoconfigure"})
public class FeignPlatformClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={PlatformClient.class})
    @NotNull
    public FeignPlatformClient feignPlatformClient(@NotNull ConnectorProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        String string = properties.getAlxndria().getUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"properties.alxndria.uri.toString()");
        return new FeignPlatformClient(string);
    }

    @Bean
    @ConditionalOnMissingBean(value={IndexClient.class})
    @NotNull
    public IndexClient feignIndexClient(@NotNull ConnectorProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        return this.feignPlatformClient(properties).getIndex();
    }

    @Bean
    @ConditionalOnMissingBean(value={DatasourceClient.class})
    @NotNull
    public DatasourceClient feignDatasourceClient(@NotNull ConnectorProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        return this.feignPlatformClient(properties).getDatasource();
    }
}

