package io.datalbry.confluence.cloud.client

import io.datalbry.confluence.cloud.client.model.ACL
import io.datalbry.confluence.cloud.client.model.ContentId
import io.datalbry.confluence.cloud.client.model.content.Content
import io.datalbry.confluence.cloud.client.model.space.SpaceKey

interface ContentClient {

    fun getContent(id: ContentId): Content

    fun getPageIds(spaceKey: SpaceKey, pageSize: Int = DEFAULT_PAGE_SIZE): Iterator<ContentId>

    fun getBlogPostIds(spaceKey: SpaceKey, pageSize: Int = DEFAULT_PAGE_SIZE): Iterator<ContentId>

    fun getRestrictions(id: ContentId, pageSize: Int = DEFAULT_PAGE_SIZE): ACL

    fun getContentAttachments(id: ContentId, pageSize: Int = DEFAULT_PAGE_SIZE): Iterator<ContentId>

    fun getContentComments(id: ContentId, pageSize: Int = DEFAULT_PAGE_SIZE): Iterator<ContentId>

    companion object {
        const val DEFAULT_PAGE_SIZE = 200
    }

}
