package io.datalbry.config.api.annotation

/**
 * [PropertyDescription] is the primary annotation used to describe configuration properties for the schema
 *
 * @param key of the property, e.g. "io.datalbry.filesystem.instance.uri"
 * @param group of the property, e.g. "io.datalbry.filesystem.instance"
 * @param type of the property, e.g. "uri", "string"...
 * @param required if the property is mandatory or not
 * @param multi if the property can be configured multiple times
 * @param description of the property, human readable
 * @param label of the property, e.g. "Filesystem Instance URI"
 * @param example of the property
 *
 * @author timo gruen - 2021-04-07
 */
@Target(
    AnnotationTarget.CLASS,
    AnnotationTarget.PROPERTY,
    AnnotationTarget.FIELD
)
@Retention(AnnotationRetention.SOURCE)
annotation class PropertyDescription(
    val key: String,
    val group: String,
    val type: String,
    val required: Boolean = REQUIRED_DEFAULT,
    val multi: Boolean = MULTI_DEFAULT,
    val description: String,
    val label: String,
    val example: Array<String> = []
) {
    companion object {
        const val REQUIRED_DEFAULT = false
        const val MULTI_DEFAULT = false
        val EXAMPLE_DEFAULT = emptySet<String>()
    }
}
