package io.datalbry.config.api.annotation

/**
 * [ConfigType] is being used for annotating configuration type classes,
 * which should be used to derive a schema-config.json.
 *
 * @see ConfigSchema for details on how a schema looks like
 * @see PropertyDescription for details on how to provide details about the properties within a [ConfigType] annotated class
 *
 * @author timo gruen - 2021-04-07
 */
@Target(AnnotationTarget.CLASS)
@Retention(AnnotationRetention.SOURCE)
annotation class ConfigType(
    val key: String = ""
)
