package io.datalbry.config.api.annotation

/**
 * [ConfigSchema] is being used for annotating configuration classes,
 * which should be used to derive a schema-config.json.
 *
 * @see io.datalbry.config.api.ConfigSchema for details on how a schema looks like in kotlin
 * @see PropertyDescription for details on how to provide details about the properties within a [ConfigSchema] annotated class
 * @see ConfigType for details on how to derive a custom type
 *
 * @author timo gruen - 2021-04-07
 */
@Target(AnnotationTarget.CLASS)
@Retention(AnnotationRetention.SOURCE)
annotation class ConfigSchema
