package io.datalbry.config.api

/**
 * [PropertyType] describes a complex type, which is not yet been covered by the [PropertyStandardType]s
 *
 * [PropertyType] are being used to describe nested, or complex types.
 *
 * @param key of the type, must be globally unique in the schema
 * @param properties describing how the [PropertyType] looks like
 *
 * @see PropertyStandardType for simple standard types
 *
 * @author timo gruen - 2021-04-07
 */
data class PropertyType(
    val key: String,
    val properties: Set<PropertyDescription>
)
