package io.datalbry.config.api

/**
 * [PropertyStandardType] describes the currently available standard types to the config framework
 *
 * @param key of the type, used by e.g. [PropertyDescription.key]
 *
 * @see PropertyType for custom complex types
 */
enum class PropertyStandardType(val key: String) {
    STRING(STRING_KEY),
    BOOLEAN(BOOLEAN_KEY),
    SECRET(SECRET_KEY),
    DURATION(DURATION_KEY),
    LONG(LONG_KEY),
    INT(INT_KEY),
    DOUBLE(DOUBLE_KEY),
    FLOAT(FLOAT_KEY),
    URI(URI_KEY);
}

const val STRING_KEY = "string"
const val BOOLEAN_KEY = "boolean"
const val SECRET_KEY = "secret"
const val DURATION_KEY = "duration"
const val LONG_KEY = "long"
const val INT_KEY = "int"
const val DOUBLE_KEY = "double"
const val FLOAT_KEY = "float"
const val URI_KEY = "uri"
