package io.datalbry.config.api

import java.util.*

/**
 * [PropertyDescription] describes a configuration property
 *
 * @param key of the property, must be globally unique
 * @param group of the property, especially useful to group multiple properties
 * @param type of the property, must be either a [PropertyStandardType], or a [PropertyType]
 * @param required describing if the property is mandatory (true) or optional (false)
 * @param multi describing if the property can be repeated multiple times
 * @param description of the property
 * @param label of the property, human readable title, likely to be derived by the key
 * @param example of the property
 *
 * @see PropertyStandardType for standard types
 * @see PropertyType to define custom complex types
 *
 * @author timo gruen - 2021-04-07
 */
data class PropertyDescription(
    val key: String,
    val group: String,
    val type: String,
    val required: Boolean = false,
    val multi: Boolean = false,
    val description: String,
    val label: String,
    val example: Set<String> = emptySet()
)

