package io.datalbry.alxndria.client.api.pagination

import java.util.*

/**
 * Simple immutable implementation for the Interface [Paginated]
 *
 * @param Payload - type of the payload
 * @param payload of the page
 * @param nextToken in string representation. The semantics are given by the actual implementation and might vary
 *
 * @see [Paginated] for more information
 * @see [MutablePage] for the mutable variant
 *
 * @author timo gruen - 2021-01-19
 */
data class ImmutablePage<Payload>(
    override val payload: Set<Payload>,
    override val nextToken: Optional<String>
) : Paginated<Payload>
