/*
 * Decompiled with CFR 0.152.
 */
package io.datalbry.alxndria.client.feign.v1.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import feign.Feign;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import io.datalbry.precise.api.schema.Schema;
import io.datalbry.precise.serialization.jackson.PreciseModule;
import io.datalbry.precise.serialization.jackson.deserializer.SchemaDeserializer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\b\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0015\u0010\u0006\u001a\u00020\u0007\"\u0006\b\u0000\u0010\b\u0018\u0001*\u00020\u0001H\u0086\b\u00a8\u0006\t"}, d2={"documentSupportingJackson", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "schema", "Lio/datalbry/precise/api/schema/Schema;", "preconfiguredJackson", "schemaSupportingJackson", "feignBuilder", "Lfeign/Feign$Builder;", "Type", "client-feign"})
public final class JacksonUtilKt {
    public static final /* synthetic */ <Type> Feign.Builder feignBuilder(ObjectMapper $this$feignBuilder) {
        int $i$f$feignBuilder = 0;
        Intrinsics.checkNotNullParameter((Object)$this$feignBuilder, (String)"$this$feignBuilder");
        Feign.Builder builder = new Feign.Builder();
        builder.decoder((Decoder)new JacksonDecoder($this$feignBuilder));
        builder.encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder($this$feignBuilder)));
        Intrinsics.reifiedOperationMarker((int)4, (String)"Type");
        builder.logger((Logger)new Slf4jLogger(Object.class));
        return builder;
    }

    @NotNull
    public static final ObjectMapper documentSupportingJackson(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        ObjectMapper jackson = JacksonUtilKt.preconfiguredJackson();
        jackson.registerModule((Module)new PreciseModule(schema));
        return jackson;
    }

    @NotNull
    public static final ObjectMapper schemaSupportingJackson() {
        ObjectMapper jackson = JacksonUtilKt.preconfiguredJackson();
        SimpleModule schemaModule = new SimpleModule().addDeserializer(Schema.class, (JsonDeserializer)new SchemaDeserializer());
        jackson.registerModule((Module)schemaModule);
        return jackson;
    }

    private static final ObjectMapper preconfiguredJackson() {
        ObjectMapper jackson = ExtensionsKt.jacksonObjectMapper();
        jackson.registerModule((Module)new Jdk8Module().configureAbsentsAsNulls(true));
        jackson.registerModule((Module)new JavaTimeModule());
        jackson.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jackson.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        return jackson;
    }
}

