package io.datalbry.alxndria.client.api.pagination

import java.util.*

/**
 * Simple mutable implementation for the Interface [Paginated]
 *
 * @param Payload - type of the payload
 * @param payload of the page
 * @param nextToken in string representation. The semantics are given by the actual implementation and might vary
 *
 * @see [Paginated] for more information
 * @see [ImmutablePage] for the immutable variant
 *
 * @author timo gruen - 2021-01-19
 */
data class MutablePage<Payload>(
    override var payload: MutableSet<Payload> = mutableSetOf(),
    override var nextToken: Optional<String> = Optional.empty()
) : Paginated<Payload>
