package io.datalbry.alxndria.client.api

import io.datalbry.alxndria.client.api.dto.Datasource
import io.datalbry.precise.api.schema.Schema

/**
 * Client implementation for the Datasource REST endpoints of the knowledge integration platform
 *
 * @author timo gruen - 2020-10-10
 */
interface DatasourceClient: AutoCloseable {

    /**
     * Put a datasource to the knowledge platform
     *
     * @param datasource to put
     */
    fun putDatasource(datasource: Datasource)

    /**
     * Delete a datasource from the knowledge platform
     *
     * @param datasourceId of the datasource to delete
     */
    fun deleteDatasource(datasourceId: String)

    /**
     * Get a datasource from the knowledge platform
     *
     * @param datasourceId of the datasource to get
     */
    fun getDatasource(datasourceId: String): Datasource

    /**
     * Put a schema onto a datasource
     *
     * (!) Note the Datasource Schema is only changeable as long as
     *     the datasource itself does not contain any item
     *
     * @param datasourceId to put the schema onto
     * @param schema to put
     */
    fun putSchema(datasourceId: String, schema: Schema)

    /**
     * Get the current configured schema of a datasource
     *
     * (!) The schema may not equal to the one being set.
     *     This is limited due to technical reasons
     *
     * @param datasourceId to get the schema from
     *
     * @return schema of the datasource
     */
    fun getSchema(datasourceId: String): Schema

    /**
     * Get all datasource ids
     *
     * @return collection of all datasource identifiers
     */
    fun getAllDatasourceIds(): Collection<String>

}
