/*
 * Decompiled with CFR 0.152.
 */
package io.cumul.sdk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Cumulio {
    private static final String API_HOST = "https://api.cumul.io";
    private static final String VERSION = "0.1.0";
    private String key;
    private String token;
    private String api_host;

    public Cumulio(String key, String token) {
        this(key, token, API_HOST);
    }

    public Cumulio(String key, String token, String api_host) {
        this.key = key;
        this.token = token;
        this.api_host = api_host;
    }

    public JSONObject create(String resource, JSONObject properties) throws IOException {
        return this.create(resource, properties, null);
    }

    public JSONObject create(String resource, ImmutableMap properties) throws IOException {
        return this.create(resource, new JSONObject((Map)properties), null);
    }

    public JSONObject create(String resource, ImmutableMap properties, ImmutableList associations) throws IOException {
        return this.create(resource, new JSONObject((Map)properties), new JSONArray((Collection)associations));
    }

    public JSONObject create(String resource, JSONObject properties, JSONArray associations) throws IOException {
        JSONObject query = new JSONObject();
        query.put("action", (Object)"create");
        query.put("properties", (Object)properties);
        query.put("associations", (Object)associations);
        return this._emit(resource, "POST", query);
    }

    public JSONObject get(String resource, ImmutableMap filter) throws IOException {
        return this.get(resource, new JSONObject((Map)filter));
    }

    public JSONObject get(String resource, JSONObject filter) throws IOException {
        JSONObject query = new JSONObject();
        query.put("action", (Object)"get");
        query.put("find", (Object)filter);
        return this._emit(resource, "SEARCH", query);
    }

    public JSONObject delete(String resource, String id) throws IOException {
        return this.delete(resource, id, new JSONObject());
    }

    public JSONObject delete(String resource, String id, ImmutableMap properties) throws IOException {
        return this.delete(resource, id, new JSONObject((Map)properties));
    }

    public JSONObject delete(String resource, String id, JSONObject properties) throws IOException {
        JSONObject query = new JSONObject();
        query.put("action", (Object)"delete");
        query.put("id", (Object)id);
        query.put("properties", (Object)properties);
        return this._emit(resource, "DELETE", query);
    }

    public JSONObject update(String resource, String id, ImmutableMap properties) throws IOException {
        return this.update(resource, id, new JSONObject((Map)properties));
    }

    public JSONObject update(String resource, String id, JSONObject properties) throws IOException {
        JSONObject query = new JSONObject();
        query.put("action", (Object)"update");
        query.put("id", (Object)id);
        query.put("properties", (Object)properties);
        return this._emit(resource, "PATCH", query);
    }

    public JSONObject associate(String resource, String id, String associationRole, String associationId) throws IOException {
        return this.associate(resource, id, associationRole, associationId, new JSONObject());
    }

    public JSONObject associate(String resource, String id, String associationRole, String associationId, ImmutableMap properties) throws IOException {
        return this.associate(resource, id, associationRole, associationId, new JSONObject((Map)properties));
    }

    public JSONObject associate(String resource, String id, String associationRole, String associationId, JSONObject properties) throws IOException {
        JSONObject association = new JSONObject();
        association.put("role", (Object)associationRole);
        association.put("id", (Object)associationId);
        JSONObject query = new JSONObject();
        query.put("action", (Object)"associate");
        query.put("id", (Object)id);
        query.put("resource", (Object)association);
        query.put("properties", (Object)properties);
        return this._emit(resource, "LINK", query);
    }

    public JSONObject dissociate(String resource, String id, String associationRole, String associationId) throws IOException {
        JSONObject association = new JSONObject();
        association.put("role", (Object)associationRole);
        association.put("id", (Object)associationId);
        JSONObject query = new JSONObject();
        query.put("action", (Object)"associate");
        query.put("id", (Object)id);
        query.put("resource", (Object)association);
        return this._emit(resource, "UNLINK", query);
    }

    public JSONObject query(JSONObject filter) throws IOException {
        return this.get("data", filter);
    }

    public JSONObject query(ImmutableMap filter) throws IOException {
        return this.get("data", filter);
    }

    private JSONObject _emit(String resource, String action, JSONObject query) throws IOException {
        String line;
        query.put("key", (Object)this.key);
        query.put("token", (Object)this.token);
        query.put("version", (Object)VERSION);
        String payload = query.toString();
        URL url = new URL(this.api_host + "/0.1.0/" + resource);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("X-HTTP-Method-Override", "PATCH");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Content-Length", Integer.toString(payload.length()));
        conn.setDoOutput(true);
        DataOutputStream dos = new DataOutputStream(conn.getOutputStream());
        dos.writeBytes(payload);
        dos.close();
        StringBuilder result = new StringBuilder();
        InputStream _is = conn.getResponseCode() < 400 ? conn.getInputStream() : conn.getErrorStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(_is));
        while ((line = br.readLine()) != null) {
            result.append(line);
        }
        try {
            return new JSONObject(result.toString());
        }
        catch (JSONException e) {
            JSONObject emptyResult = new JSONObject();
            emptyResult.put("result", (Object)result);
            return emptyResult;
        }
    }
}

