package org.treblereel.produces.qualifier;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import io.crysknife.client.BeanManagerImpl;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import io.crysknife.client.Instance;

@Aspect()
public class QualifierBeanProducerTestInfo {

    private Supplier<Instance<org.treblereel.produces.qualifier.QualifierBean>> qualifierBean = () -> BeanManagerImpl.get().lookupBean(org.treblereel.produces.qualifier.QualifierBean.class);

    @Around(value = "get(* org.treblereel.produces.qualifier.QualifierBeanProducerTest.qualifierBean)")
    public Object qualifierBean(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "qualifierBean", qualifierBean.get());
    }

    private Object onInvoke(ProceedingJoinPoint joinPoint, String fieldName, Instance instance) throws Throwable {
        Field field;
        try {
            field = joinPoint.getTarget().getClass().getDeclaredField(fieldName);
        } catch (NoSuchFieldException e) {
            throw new Error(e);
        }
        field.setAccessible(true);
        if (field.get(joinPoint.getTarget()) != null)
            return joinPoint.proceed();
        try {
            field.set(joinPoint.getTarget(), instance.get());
        } catch (IllegalAccessException e) {
            throw new Error(e);
        }
        return joinPoint.proceed();
    }
}
