package org.treblereel.produces;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import io.crysknife.client.BeanManagerImpl;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import io.crysknife.client.Instance;

@Aspect()
public class SimpleBeanProducerTestInfo {

    private Supplier<Instance<org.treblereel.produces.SimpleBeanSingleton>> simpleBeanSingletonOne = () -> BeanManagerImpl.get().lookupBean(org.treblereel.produces.SimpleBeanSingleton.class);

    @Around(value = "get(* org.treblereel.produces.SimpleBeanProducerTest.simpleBeanSingletonOne)")
    public Object simpleBeanSingletonOne(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "simpleBeanSingletonOne", simpleBeanSingletonOne.get());
    }

    private Supplier<Instance<org.treblereel.produces.SimpleBeanSingleton>> simpleBeanSingletonTwo = () -> BeanManagerImpl.get().lookupBean(org.treblereel.produces.SimpleBeanSingleton.class);

    @Around(value = "get(* org.treblereel.produces.SimpleBeanProducerTest.simpleBeanSingletonTwo)")
    public Object simpleBeanSingletonTwo(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "simpleBeanSingletonTwo", simpleBeanSingletonTwo.get());
    }

    private Supplier<Instance<org.treblereel.produces.SimpleBeanDependent>> simpleBeanDependentOne = () -> BeanManagerImpl.get().lookupBean(org.treblereel.produces.SimpleBeanDependent.class);

    @Around(value = "get(* org.treblereel.produces.SimpleBeanProducerTest.simpleBeanDependentOne)")
    public Object simpleBeanDependentOne(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "simpleBeanDependentOne", simpleBeanDependentOne.get());
    }

    private Supplier<Instance<org.treblereel.produces.SimpleBeanDependent>> simpleBeanDependentTwo = () -> BeanManagerImpl.get().lookupBean(org.treblereel.produces.SimpleBeanDependent.class);

    @Around(value = "get(* org.treblereel.produces.SimpleBeanProducerTest.simpleBeanDependentTwo)")
    public Object simpleBeanDependentTwo(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "simpleBeanDependentTwo", simpleBeanDependentTwo.get());
    }

    private Object onInvoke(ProceedingJoinPoint joinPoint, String fieldName, Instance instance) throws Throwable {
        Field field;
        try {
            field = joinPoint.getTarget().getClass().getDeclaredField(fieldName);
        } catch (NoSuchFieldException e) {
            throw new Error(e);
        }
        field.setAccessible(true);
        if (field.get(joinPoint.getTarget()) != null)
            return joinPoint.proceed();
        try {
            field.set(joinPoint.getTarget(), instance.get());
        } catch (IllegalAccessException e) {
            throw new Error(e);
        }
        return joinPoint.proceed();
    }
}
