package org.treblereel.produces;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import io.crysknife.client.BeanManagerImpl;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import io.crysknife.client.Instance;

@Aspect()
public class SimpleBeanProducerInfo {

    private Supplier<Instance<org.treblereel.produces.RandomGenerator>> randomGenerator = () -> BeanManagerImpl.get().lookupBean(org.treblereel.produces.RandomGenerator.class);

    @Around(value = "get(* org.treblereel.produces.SimpleBeanProducer.randomGenerator)")
    public Object randomGenerator(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "randomGenerator", randomGenerator.get());
    }

    private Object onInvoke(ProceedingJoinPoint joinPoint, String fieldName, Instance instance) throws Throwable {
        Field field;
        try {
            field = joinPoint.getTarget().getClass().getDeclaredField(fieldName);
        } catch (NoSuchFieldException e) {
            throw new Error(e);
        }
        field.setAccessible(true);
        if (field.get(joinPoint.getTarget()) != null)
            return joinPoint.proceed();
        try {
            field.set(joinPoint.getTarget(), instance.get());
        } catch (IllegalAccessException e) {
            throw new Error(e);
        }
        return joinPoint.proceed();
    }
}
