package org.treblereel.injection.singleton;

import io.crysknife.client.internal.Factory;
import javax.inject.Provider;
import io.crysknife.client.internal.OnFieldAccessed;
import io.crysknife.client.Reflect;

public class SingletonBean_Factory implements Factory<SingletonBean> {

    @Override()
    public SingletonBean get() {
        if (this.instance != null)
            return this.instance;
        this.instance = new SingletonBean();
        this.instance.init();
        return this.instance;
    }

    private SingletonBean instance;

    private SingletonBean_Factory() {
    }

    public static SingletonBean_Factory create() {
        return new SingletonBean_Factory();
    }
}
