package org.treblereel.injection.singleton;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import io.crysknife.client.BeanManagerImpl;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import io.crysknife.client.Instance;

@Aspect()
public class SimpleSingletonTestInfo {

    private Supplier<Instance<org.treblereel.injection.singleton.SingletonBean>> fieldOne = () -> BeanManagerImpl.get().lookupBean(org.treblereel.injection.singleton.SingletonBean.class);

    @Around(value = "get(* org.treblereel.injection.singleton.SimpleSingletonTest.fieldOne)")
    public Object fieldOne(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "fieldOne", fieldOne.get());
    }

    private Supplier<Instance<org.treblereel.injection.singleton.SingletonBean>> fieldTwo = () -> BeanManagerImpl.get().lookupBean(org.treblereel.injection.singleton.SingletonBean.class);

    @Around(value = "get(* org.treblereel.injection.singleton.SimpleSingletonTest.fieldTwo)")
    public Object fieldTwo(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "fieldTwo", fieldTwo.get());
    }

    private Object onInvoke(ProceedingJoinPoint joinPoint, String fieldName, Instance instance) throws Throwable {
        Field field;
        try {
            field = joinPoint.getTarget().getClass().getDeclaredField(fieldName);
        } catch (NoSuchFieldException e) {
            throw new Error(e);
        }
        field.setAccessible(true);
        if (field.get(joinPoint.getTarget()) != null)
            return joinPoint.proceed();
        try {
            field.set(joinPoint.getTarget(), instance.get());
        } catch (IllegalAccessException e) {
            throw new Error(e);
        }
        return joinPoint.proceed();
    }
}
