package org.treblereel.injection.singleton;

import io.crysknife.client.internal.Factory;
import javax.inject.Provider;
import io.crysknife.client.internal.OnFieldAccessed;
import io.crysknife.client.Reflect;

public class SimpleBeanSingleton_Factory implements Factory<SimpleBeanSingleton> {

    @Override()
    public SimpleBeanSingleton get() {
        if (this.instance != null)
            return this.instance;
        this.instance = new SimpleBeanSingleton();
        this.instance.init();
        return this.instance;
    }

    private SimpleBeanSingleton instance;

    private SimpleBeanSingleton_Factory() {
    }

    public static SimpleBeanSingleton_Factory create() {
        return new SimpleBeanSingleton_Factory();
    }
}
