package org.treblereel.injection.qualifiers;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import io.crysknife.client.BeanManagerImpl;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import io.crysknife.client.Instance;

@Aspect()
public class QualifierConstructorInjectionInfo {

    private Supplier<Instance<org.treblereel.injection.qualifiers.QualifierBeanDefault>> qualifier = () -> BeanManagerImpl.get().lookupBean(org.treblereel.injection.qualifiers.QualifierBeanDefault.class);

    @Around(value = "get(* org.treblereel.injection.qualifiers.QualifierConstructorInjection.qualifier)")
    public Object qualifier(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "qualifier", qualifier.get());
    }

    private Object onInvoke(ProceedingJoinPoint joinPoint, String fieldName, Instance instance) throws Throwable {
        Field field;
        try {
            field = joinPoint.getTarget().getClass().getDeclaredField(fieldName);
        } catch (NoSuchFieldException e) {
            throw new Error(e);
        }
        field.setAccessible(true);
        if (field.get(joinPoint.getTarget()) != null)
            return joinPoint.proceed();
        try {
            field.set(joinPoint.getTarget(), instance.get());
        } catch (IllegalAccessException e) {
            throw new Error(e);
        }
        return joinPoint.proceed();
    }
}
