package org.treblereel.injection.named;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import io.crysknife.client.BeanManagerImpl;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import io.crysknife.client.Instance;

@Aspect()
public class NamedTestBeanInfo {

    private Supplier<Instance<org.treblereel.injection.named.NamedConstructorInjection>> namedConstructorInjection = () -> BeanManagerImpl.get().lookupBean(org.treblereel.injection.named.NamedConstructorInjection.class);

    @Around(value = "get(* org.treblereel.injection.named.NamedTestBean.namedConstructorInjection)")
    public Object namedConstructorInjection(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "namedConstructorInjection", namedConstructorInjection.get());
    }

    private Supplier<Instance<org.treblereel.injection.named.NamedFieldInjection>> namedFieldInjection = () -> BeanManagerImpl.get().lookupBean(org.treblereel.injection.named.NamedFieldInjection.class);

    @Around(value = "get(* org.treblereel.injection.named.NamedTestBean.namedFieldInjection)")
    public Object namedFieldInjection(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "namedFieldInjection", namedFieldInjection.get());
    }

    private Object onInvoke(ProceedingJoinPoint joinPoint, String fieldName, Instance instance) throws Throwable {
        Field field;
        try {
            field = joinPoint.getTarget().getClass().getDeclaredField(fieldName);
        } catch (NoSuchFieldException e) {
            throw new Error(e);
        }
        field.setAccessible(true);
        if (field.get(joinPoint.getTarget()) != null)
            return joinPoint.proceed();
        try {
            field.set(joinPoint.getTarget(), instance.get());
        } catch (IllegalAccessException e) {
            throw new Error(e);
        }
        return joinPoint.proceed();
    }
}
