package org.treblereel.injection.named;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import io.crysknife.client.BeanManagerImpl;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import io.crysknife.client.Instance;

@Aspect()
public class NamedFieldInjectionInfo {

    private Supplier<Instance<org.treblereel.injection.named.NamedBean>> one = () -> BeanManagerImpl.get().lookupBean(org.treblereel.injection.named.NamedBeanOne.class);

    @Around(value = "get(* org.treblereel.injection.named.NamedFieldInjection.one)")
    public Object one(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "one", one.get());
    }

    private Supplier<Instance<org.treblereel.injection.named.NamedBean>> two = () -> BeanManagerImpl.get().lookupBean(org.treblereel.injection.named.NamedBeanTwo.class);

    @Around(value = "get(* org.treblereel.injection.named.NamedFieldInjection.two)")
    public Object two(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "two", two.get());
    }

    private Supplier<Instance<org.treblereel.injection.named.NamedBeanDefault>> def = () -> BeanManagerImpl.get().lookupBean(org.treblereel.injection.named.NamedBeanDefault.class);

    @Around(value = "get(* org.treblereel.injection.named.NamedFieldInjection.def)")
    public Object def(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "def", def.get());
    }

    private Object onInvoke(ProceedingJoinPoint joinPoint, String fieldName, Instance instance) throws Throwable {
        Field field;
        try {
            field = joinPoint.getTarget().getClass().getDeclaredField(fieldName);
        } catch (NoSuchFieldException e) {
            throw new Error(e);
        }
        field.setAccessible(true);
        if (field.get(joinPoint.getTarget()) != null)
            return joinPoint.proceed();
        try {
            field.set(joinPoint.getTarget(), instance.get());
        } catch (IllegalAccessException e) {
            throw new Error(e);
        }
        return joinPoint.proceed();
    }
}
