package org.treblereel;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import io.crysknife.client.BeanManagerImpl;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import io.crysknife.client.Instance;

@Aspect()
public class AppInfo {

    private Supplier<Instance<org.treblereel.injection.qualifiers.QualifierFieldInjection>> qualifierFieldInjection = () -> BeanManagerImpl.get().lookupBean(org.treblereel.injection.qualifiers.QualifierFieldInjection.class);

    @Around(value = "get(* org.treblereel.App.qualifierFieldInjection)")
    public Object qualifierFieldInjection(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "qualifierFieldInjection", qualifierFieldInjection.get());
    }

    private Supplier<Instance<org.treblereel.injection.qualifiers.QualifierConstructorInjection>> qualifierConstructorInjection = () -> BeanManagerImpl.get().lookupBean(org.treblereel.injection.qualifiers.QualifierConstructorInjection.class);

    @Around(value = "get(* org.treblereel.App.qualifierConstructorInjection)")
    public Object qualifierConstructorInjection(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "qualifierConstructorInjection", qualifierConstructorInjection.get());
    }

    private Supplier<Instance<org.treblereel.injection.dependent.SimpleDependentTest>> simpleDependentTest = () -> BeanManagerImpl.get().lookupBean(org.treblereel.injection.dependent.SimpleDependentTest.class);

    @Around(value = "get(* org.treblereel.App.simpleDependentTest)")
    public Object simpleDependentTest(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "simpleDependentTest", simpleDependentTest.get());
    }

    private Supplier<Instance<org.treblereel.injection.singleton.SimpleSingletonTest>> simpleSingletonTest = () -> BeanManagerImpl.get().lookupBean(org.treblereel.injection.singleton.SimpleSingletonTest.class);

    @Around(value = "get(* org.treblereel.App.simpleSingletonTest)")
    public Object simpleSingletonTest(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "simpleSingletonTest", simpleSingletonTest.get());
    }

    private Supplier<Instance<org.treblereel.injection.applicationscoped.SimpleBeanApplicationScoped>> simpleBeanApplicationScoped = () -> BeanManagerImpl.get().lookupBean(org.treblereel.injection.applicationscoped.SimpleBeanApplicationScoped.class);

    @Around(value = "get(* org.treblereel.App.simpleBeanApplicationScoped)")
    public Object simpleBeanApplicationScoped(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "simpleBeanApplicationScoped", simpleBeanApplicationScoped.get());
    }

    private Supplier<Instance<org.treblereel.injection.singleton.SimpleBeanSingleton>> simpleBeanSingleton = () -> BeanManagerImpl.get().lookupBean(org.treblereel.injection.singleton.SimpleBeanSingleton.class);

    @Around(value = "get(* org.treblereel.App.simpleBeanSingleton)")
    public Object simpleBeanSingleton(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "simpleBeanSingleton", simpleBeanSingleton.get());
    }

    private Supplier<Instance<org.treblereel.injection.dependent.SimpleBeanDependent>> simpleBeanDependent = () -> BeanManagerImpl.get().lookupBean(org.treblereel.injection.dependent.SimpleBeanDependent.class);

    @Around(value = "get(* org.treblereel.App.simpleBeanDependent)")
    public Object simpleBeanDependent(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "simpleBeanDependent", simpleBeanDependent.get());
    }

    private Supplier<Instance<org.treblereel.injection.named.NamedTestBean>> namedTestBean = () -> BeanManagerImpl.get().lookupBean(org.treblereel.injection.named.NamedTestBean.class);

    @Around(value = "get(* org.treblereel.App.namedTestBean)")
    public Object namedTestBean(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "namedTestBean", namedTestBean.get());
    }

    private Supplier<Instance<org.treblereel.produces.SimpleBeanProducerTest>> simpleBeanProducerTest = () -> BeanManagerImpl.get().lookupBean(org.treblereel.produces.SimpleBeanProducerTest.class);

    @Around(value = "get(* org.treblereel.App.simpleBeanProducerTest)")
    public Object simpleBeanProducerTest(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "simpleBeanProducerTest", simpleBeanProducerTest.get());
    }

    private Supplier<Instance<org.treblereel.produces.qualifier.QualifierBeanProducerTest>> qualifierBeanProducerTest = () -> BeanManagerImpl.get().lookupBean(org.treblereel.produces.qualifier.QualifierBeanProducerTest.class);

    @Around(value = "get(* org.treblereel.App.qualifierBeanProducerTest)")
    public Object qualifierBeanProducerTest(ProceedingJoinPoint joinPoint) throws Throwable {
        return onInvoke(joinPoint, "qualifierBeanProducerTest", qualifierBeanProducerTest.get());
    }

    private Object onInvoke(ProceedingJoinPoint joinPoint, String fieldName, Instance instance) throws Throwable {
        Field field;
        try {
            field = joinPoint.getTarget().getClass().getDeclaredField(fieldName);
        } catch (NoSuchFieldException e) {
            throw new Error(e);
        }
        field.setAccessible(true);
        if (field.get(joinPoint.getTarget()) != null)
            return joinPoint.proceed();
        try {
            field.set(joinPoint.getTarget(), instance.get());
        } catch (IllegalAccessException e) {
            throw new Error(e);
        }
        return joinPoint.proceed();
    }
}
