/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.dom.client;

import elemental2.dom.HTMLElement;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import org.gwtproject.core.client.JavaScriptObject;
import org.gwtproject.dom.client.Document;
import org.gwtproject.dom.client.Element;
import org.gwtproject.dom.client.NodeList;

@JsType(isNative=true, name="Object", namespace="<global>")
public class Node
extends JavaScriptObject {
    @JsProperty(namespace="<global>", name="Node.ELEMENT_NODE")
    public static short ELEMENT_NODE;
    @JsProperty(namespace="<global>", name="Node.TEXT_NODE")
    public static short TEXT_NODE;
    @JsProperty(namespace="<global>", name="Node.DOCUMENT_NODE")
    public static short DOCUMENT_NODE;

    @JsOverlay
    public static Node as(JavaScriptObject o) {
        assert (Node.is(o));
        return (Node)o;
    }

    @JsOverlay
    public static boolean is(JavaScriptObject o) {
        try {
            return Js.isTruthy(o) && Js.isTruthy(Js.asPropertyMap(o).get("nodeType"));
        }
        catch (Exception e) {
            return false;
        }
    }

    protected Node() {
    }

    public final native <T extends Node> T appendChild(T var1);

    public final native Node cloneNode(boolean var1);

    @JsOverlay
    public final Node getChild(int index) {
        assert (index >= 0 && index < this.getChildCount()) : "Child index out of bounds";
        return this.getChildNodes().getItem(index);
    }

    @JsOverlay
    public final int getChildCount() {
        return this.getChildNodes().getLength();
    }

    @JsProperty
    public final native NodeList<Node> getChildNodes();

    @JsProperty
    public final native Node getFirstChild();

    @JsProperty
    public final native Node getLastChild();

    @JsProperty
    public final native Node getNextSibling();

    @JsProperty
    public final native String getNodeName();

    @JsProperty
    public final native short getNodeType();

    @JsProperty
    public final native String getNodeValue();

    @JsProperty
    public final native Document getOwnerDocument();

    @JsOverlay
    public final Element getParentElement() {
        elemental2.dom.Node parent = ((elemental2.dom.Node)Js.uncheckedCast((Object)this)).parentNode;
        if (parent == null || parent.nodeType != 1) {
            parent = null;
        }
        return (Element)Js.uncheckedCast(parent);
    }

    @JsProperty
    public final native Node getParentNode();

    @JsProperty
    public final native Node getPreviousSibling();

    public final native boolean hasChildNodes();

    @JsOverlay
    public final boolean hasParentElement() {
        return this.getParentElement() != null;
    }

    @JsOverlay
    public final Node insertAfter(Node newChild, Node refChild) {
        Node next;
        assert (newChild != null) : "Cannot add a null child node";
        Node node = next = refChild == null ? null : refChild.getNextSibling();
        if (next == null) {
            return this.appendChild(newChild);
        }
        return this.insertBefore(newChild, next);
    }

    public final native Node insertBefore(Node var1, Node var2);

    @JsOverlay
    public final Node insertFirst(Node child) {
        assert (child != null) : "Cannot add a null child node";
        return this.insertBefore(child, this.getFirstChild());
    }

    @JsOverlay
    public final boolean isOrHasChild(Node child) {
        assert (child != null) : "Child cannot be null";
        return ((HTMLElement)Js.uncheckedCast(this)).contains((elemental2.dom.Node)Js.uncheckedCast(child));
    }

    public final native Node removeChild(Node var1);

    @JsOverlay
    public final Node removeAllChildren() {
        while (this.getLastChild() != null) {
            this.removeChild(this.getLastChild());
        }
        return null;
    }

    @JsOverlay
    public final void removeFromParent() {
        Element parent = this.getParentElement();
        if (parent != null) {
            parent.removeChild(this);
        }
    }

    public final native Node replaceChild(Node var1, Node var2);

    @JsProperty
    public final native void setNodeValue(String var1);
}

