/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.dom.client;

import elemental2.dom.HTMLMediaElement;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import org.gwtproject.dom.client.Element;
import org.gwtproject.media.dom.client.MediaError;
import org.gwtproject.media.dom.client.TimeRanges;

@JsType(isNative=true, name="Object", namespace="<global>")
public class MediaElement
extends Element {
    @JsOverlay
    public static final String CAN_PLAY_PROBABLY = "probably";
    @JsOverlay
    public static final String CAN_PLAY_MAYBE = "maybe";
    @JsOverlay
    public static final String CANNOT_PLAY = "";
    @JsProperty(namespace="<global>", name="HTMLMediaElement.HAVE_NOTHING")
    public static int HAVE_NOTHING;
    @JsProperty(namespace="<global>", name="HTMLMediaElement.HAVE_METADATA")
    public static int HAVE_METADATA;
    @JsProperty(namespace="<global>", name="HTMLMediaElement.HAVE_CURRENT_DATA")
    public static int HAVE_CURRENT_DATA;
    @JsProperty(namespace="<global>", name="HTMLMediaElement.HAVE_FUTURE_DATA")
    public static int HAVE_FUTURE_DATA;
    @JsProperty(namespace="<global>", name="HTMLMediaElement.HAVE_ENOUGH_DATA")
    public static int HAVE_ENOUGH_DATA;
    @JsProperty(namespace="<global>", name="HTMLMediaElement.NETWORK_EMPTY")
    public static int NETWORK_EMPTY;
    @JsProperty(namespace="<global>", name="HTMLMediaElement.NETWORK_IDLE")
    public static int NETWORK_IDLE;
    @JsProperty(namespace="<global>", name="HTMLMediaElement.NETWORK_LOADING")
    public static int NETWORK_LOADING;
    @JsProperty(namespace="<global>", name="HTMLMediaElement.NETWORK_NO_SOURCE")
    public static int NETWORK_NO_SOURCE;
    @JsOverlay
    public static final String PRELOAD_AUTO = "auto";
    @JsOverlay
    public static final String PRELOAD_METADATA = "metadata";
    @JsOverlay
    public static final String PRELOAD_NONE = "none";
    @JsProperty
    private MediaError error;
    @JsProperty
    private Object playbackRate;

    protected MediaElement() {
    }

    @JsOverlay
    public final String canPlayType(String type) {
        String canPlayType = ((HTMLMediaElement)Js.uncheckedCast(this)).canPlayType(type);
        return "no".equals(canPlayType) ? CANNOT_PLAY : canPlayType;
    }

    @JsProperty
    public final native TimeRanges getBuffered();

    @JsProperty
    public final native String getCurrentSrc();

    @JsProperty
    public final native double getCurrentTime();

    @JsOverlay
    public final double getDefaultPlaybackRate() {
        return this.getDoubleAttr("defaultPlaybackRate", 1.0);
    }

    @JsProperty
    public final native double getDuration();

    @JsOverlay
    public final MediaError getError() {
        return Js.isTruthy(this.error) ? this.error : null;
    }

    @JsOverlay
    public final double getInitialTime() {
        return this.getDoubleAttr("initialTime", 0.0);
    }

    @JsProperty
    public final native int getNetworkState();

    @JsOverlay
    public final double getPlaybackRate() {
        Object rate = this.playbackRate;
        if (rate != null && "number".equals(Js.typeof(rate))) {
            return (Double)rate;
        }
        return 1.0;
    }

    @JsProperty
    public final native TimeRanges getPlayed();

    @JsProperty
    public final native String getPreload();

    @JsProperty
    public final native int getReadyState();

    @JsProperty
    public final native TimeRanges getSeekable();

    @JsOverlay
    public final String getSrc() {
        return this.getAttribute("src");
    }

    @JsOverlay
    public final double getStartOffsetTime() {
        return this.getDoubleAttr("startOffsetTime", Double.NaN);
    }

    @JsProperty
    public final native double getVolume();

    @JsOverlay
    public final boolean hasControls() {
        return this.hasAttribute("controls");
    }

    @JsProperty(name="ended")
    public final native boolean hasEnded();

    @JsOverlay
    public final boolean isAutoplay() {
        return this.hasAttribute("autoplay");
    }

    @JsOverlay
    public final boolean isLoop() {
        return this.hasAttribute("loop");
    }

    @JsOverlay
    public final boolean isMuted() {
        return Js.isTruthy(((HTMLMediaElement)Js.uncheckedCast((Object)this)).muted);
    }

    @JsOverlay
    public final boolean isPaused() {
        return Js.isTruthy(((HTMLMediaElement)Js.uncheckedCast((Object)this)).paused);
    }

    @JsOverlay
    public final boolean isSeeking() {
        return Js.isTruthy(((HTMLMediaElement)Js.uncheckedCast((Object)this)).seeking);
    }

    public final native void load();

    public final native void pause();

    public final native void play();

    @JsOverlay
    public final void setAutoplay(boolean autoplay) {
        this.setBooleanAttr("autoplay", autoplay);
    }

    @JsOverlay
    public final void setControls(boolean controls) {
        this.setBooleanAttr("controls", controls);
    }

    @JsProperty
    public final native void setCurrentTime(double var1);

    @JsProperty
    public final native void setDefaultPlaybackRate(double var1);

    @JsOverlay
    public final void setLoop(boolean loop) {
        this.setBooleanAttr("loop", loop);
    }

    @JsProperty
    public final native void setMuted(boolean var1);

    @JsProperty
    public final native void setPlaybackRate(double var1);

    @JsProperty
    public final native void setPreload(String var1);

    @JsProperty
    public final native void setSrc(String var1);

    @JsProperty
    public final native void setVolume(double var1);

    @JsOverlay
    private double getDoubleAttr(String name, double def) {
        String value = this.getAttribute(name);
        if (!"number".equals(Js.typeof(value))) {
            return def;
        }
        return (Double)Js.uncheckedCast(value);
    }

    @JsOverlay
    private void setBooleanAttr(String name, boolean value) {
        if (value) {
            this.setAttribute(name, CANNOT_PLAY);
        } else {
            this.removeAttribute(name);
        }
    }
}

