/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.dom.client;

import java.util.Locale;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsType;
import org.gwtproject.core.client.JavaScriptObject;
import org.gwtproject.dom.client.Element;
import org.gwtproject.dom.client.Node;
import org.gwtproject.dom.client.TagName;

@JsType(isNative=true, name="Object", namespace="<global>")
@TagName(value={"h1", "h2", "h3", "h4", "h5", "h6"})
public class HeadingElement
extends Element {
    @JsOverlay
    static final String[] TAGS = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
    @JsOverlay
    public static final String TAG_H1 = "h1";
    @JsOverlay
    public static final String TAG_H2 = "h2";
    @JsOverlay
    public static final String TAG_H3 = "h3";
    @JsOverlay
    public static final String TAG_H4 = "h4";
    @JsOverlay
    public static final String TAG_H5 = "h5";
    @JsOverlay
    public static final String TAG_H6 = "h6";

    @JsOverlay
    public static HeadingElement as(Element elem) {
        if (HeadingElement.class.desiredAssertionStatus()) assert (HeadingElement.is(elem));
        return (HeadingElement)elem;
    }

    @JsOverlay
    public static boolean is(JavaScriptObject o) {
        if (Element.is(o)) {
            return HeadingElement.is((Element)o);
        }
        return false;
    }

    @JsOverlay
    public static boolean is(Node node) {
        if (Element.is(node)) {
            return HeadingElement.is((Element)node);
        }
        return false;
    }

    @JsOverlay
    public static boolean is(Element elem) {
        if (elem == null) {
            return false;
        }
        String tag = elem.getTagName().toLowerCase(Locale.ROOT);
        if (tag.length() != 2) {
            return false;
        }
        if (tag.charAt(0) != 'h') {
            return false;
        }
        int n = Integer.parseInt(tag.substring(1, 2));
        return n >= 1 && n <= 6;
    }

    protected HeadingElement() {
    }
}

