/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.dom.client;

import elemental2.core.Global;
import elemental2.dom.Event;
import elemental2.dom.HTMLElement;
import elemental2.dom.ViewCSS;
import java.util.Objects;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;
import org.gwtproject.core.client.JavaScriptObject;
import org.gwtproject.dom.client.NativeEvent;
import org.gwtproject.dom.client.Node;
import org.gwtproject.dom.client.NodeList;
import org.gwtproject.dom.client.Style;
import org.gwtproject.safehtml.shared.SafeHtml;
import org.gwtproject.safehtml.shared.annotations.IsSafeHtml;

@JsType(isNative=true, name="Object", namespace="<global>")
public class Element
extends Node {
    @JsOverlay
    public static final String DRAGGABLE_AUTO = "auto";
    @JsOverlay
    public static final String DRAGGABLE_FALSE = "false";
    @JsOverlay
    public static final String DRAGGABLE_TRUE = "true";
    @JsProperty
    private String draggable;

    @JsOverlay
    private static int toInt32(double val) {
        return Js.coerceToInt(val);
    }

    @JsOverlay
    public static Element as(JavaScriptObject o) {
        assert (Element.is(o));
        return (Element)o;
    }

    @JsOverlay
    public static Element as(Node node) {
        assert (Element.is(node));
        return (Element)node;
    }

    @JsOverlay
    public static boolean is(JavaScriptObject o) {
        if (Node.is(o)) {
            return Element.is((Node)o);
        }
        return false;
    }

    @JsOverlay
    public static boolean is(Node node) {
        return node != null && node.getNodeType() == Node.ELEMENT_NODE;
    }

    protected Element() {
    }

    @JsOverlay
    public final boolean addClassName(String className) {
        className = Element.trimClassName(className);
        String oldClassName = this.getClassName();
        int idx = Element.indexOfName(oldClassName, className);
        if (idx == -1) {
            if (oldClassName.length() > 0) {
                this.setClassName(oldClassName + " " + className);
            } else {
                this.setClassName(className);
            }
            return true;
        }
        return false;
    }

    public final native void blur();

    @JsOverlay
    public final void dispatchEvent(NativeEvent evt) {
        ((HTMLElement)Js.uncheckedCast(this)).dispatchEvent((Event)Js.uncheckedCast(evt));
    }

    public final native void focus();

    @JsOverlay
    public final int getAbsoluteBottom() {
        return this.getAbsoluteTop() + this.getOffsetHeight();
    }

    @JsOverlay
    public final int getAbsoluteLeft() {
        HTMLElement e = (HTMLElement)Js.uncheckedCast(this);
        double subPixelAbsoluteLeft = e.getBoundingClientRect().left + (double)this.getOwnerDocument().getScrollLeft();
        return Js.coerceToInt(subPixelAbsoluteLeft);
    }

    @JsOverlay
    public final int getAbsoluteRight() {
        return this.getAbsoluteLeft() + this.getOffsetWidth();
    }

    @JsOverlay
    public final int getAbsoluteTop() {
        HTMLElement e = (HTMLElement)Js.uncheckedCast(this);
        double subPixelAbsoluteTop = e.getBoundingClientRect().top + (double)this.getOwnerDocument().getScrollTop();
        return Js.coerceToInt(subPixelAbsoluteTop);
    }

    @JsOverlay
    public final String getAttribute(String name) {
        String value = ((HTMLElement)Js.uncheckedCast(this)).getAttribute(name);
        return value != null ? value : "";
    }

    @JsOverlay
    public final String getClassName() {
        String className = ((HTMLElement)Js.uncheckedCast((Object)this)).className;
        return className == null ? "" : className;
    }

    @JsOverlay
    public final int getClientHeight() {
        return Element.toInt32(this.getSubPixelClientHeight());
    }

    @JsOverlay
    public final int getClientWidth() {
        return Element.toInt32(this.getSubPixelClientWidth());
    }

    @JsProperty
    public final native String getDir();

    @JsOverlay
    public final String getDraggable() {
        return Js.isTruthy(this.draggable) ? this.draggable : null;
    }

    public final native NodeList<Element> getElementsByTagName(String var1);

    @JsOverlay
    public final Element getFirstChildElement() {
        elemental2.dom.Node child = ((HTMLElement)Js.uncheckedCast((Object)this)).firstChild;
        while (child != null && child.nodeType != 1) {
            child = child.nextSibling;
        }
        return (Element)Js.uncheckedCast(child);
    }

    @JsProperty
    public final native String getId();

    @JsOverlay
    public final String getInnerHTML() {
        return ((HTMLElement)Js.uncheckedCast((Object)this)).innerHTML;
    }

    @JsOverlay
    public final String getInnerText() {
        return ((HTMLElement)Js.uncheckedCast((Object)this)).textContent;
    }

    @JsProperty
    public final native String getLang();

    @JsOverlay
    public final Element getNextSiblingElement() {
        elemental2.dom.Node sib = ((HTMLElement)Js.uncheckedCast((Object)this)).nextSibling;
        while (sib != null && sib.nodeType != 1) {
            sib = sib.nextSibling;
        }
        return (Element)Js.uncheckedCast(sib);
    }

    @JsOverlay
    public final int getOffsetHeight() {
        return Element.toInt32(this.getSubPixelOffsetHeight());
    }

    @JsOverlay
    public final int getOffsetLeft() {
        return Element.toInt32(this.getSubPixelOffsetLeft());
    }

    @JsProperty
    public final native Element getOffsetParent();

    @JsOverlay
    public final int getOffsetTop() {
        return Element.toInt32(this.getSubPixelOffsetTop());
    }

    @JsOverlay
    public final int getOffsetWidth() {
        return Element.toInt32(this.getSubPixelOffsetWidth());
    }

    @JsOverlay
    public final Element getPreviousSiblingElement() {
        elemental2.dom.Node sib = ((HTMLElement)Js.uncheckedCast((Object)this)).previousSibling;
        while (sib != null && sib.nodeType != 1) {
            sib = sib.previousSibling;
        }
        return (Element)Js.uncheckedCast(sib);
    }

    @JsOverlay
    public final boolean getPropertyBoolean(String name) {
        return Js.isTruthy(Js.asPropertyMap(this).get(name));
    }

    @JsOverlay
    public final double getPropertyDouble(String name) {
        double value = Global.parseFloat(Js.asPropertyMap(this).get(name));
        return Double.isNaN(value) ? 0.0 : value;
    }

    @JsOverlay
    public final int getPropertyInt(String name) {
        return Js.coerceToInt(Global.parseInt(Js.asPropertyMap(this).get(name), 10));
    }

    @JsOverlay
    public final JavaScriptObject getPropertyJSO(String name) {
        JavaScriptObject value = (JavaScriptObject)Js.uncheckedCast(Js.asPropertyMap(this).get(name));
        return Js.isTruthy(value) ? value : null;
    }

    @JsOverlay
    public final Object getPropertyObject(String name) {
        return Js.asPropertyMap(this).get(name);
    }

    @JsOverlay
    public final String getPropertyString(String name) {
        Object value = Js.asPropertyMap(this).get(name);
        return value == null ? null : "" + value;
    }

    @JsOverlay
    public final int getScrollHeight() {
        return Element.toInt32(this.getSubPixelScrollHeight());
    }

    @JsOverlay
    public final int getScrollLeft() {
        int scrollLeft = Js.coerceToInt(((HTMLElement)Js.uncheckedCast((Object)this)).scrollLeft);
        if (UserAgentHolder.IS_SAFARI && !this.hasTagName("body") && !this.hasTagName("HTML") && this.isRTLSafari()) {
            return scrollLeft - (this.getScrollWidth() - this.getClientWidth());
        }
        return scrollLeft;
    }

    @JsOverlay
    public final int getScrollTop() {
        return Element.toInt32(this.getSubPixelScrollTop());
    }

    @JsOverlay
    public final int getScrollWidth() {
        return Element.toInt32(this.getSubPixelScrollWidth());
    }

    @JsOverlay
    public final String getString() {
        return (String)((JsPropertyMap)Js.uncheckedCast(this)).get("outerHTML");
    }

    @JsProperty
    public final native Style getStyle();

    @JsOverlay
    public final int getTabIndex() {
        return ((HTMLElement)Js.uncheckedCast((Object)this)).tabIndex;
    }

    @JsOverlay
    public final String getTagName() {
        return ((HTMLElement)Js.uncheckedCast((Object)this)).tagName;
    }

    @JsProperty
    public final native String getTitle();

    @JsOverlay
    public final boolean hasAttribute(String name) {
        return ((HTMLElement)Js.uncheckedCast(this)).hasAttribute(name);
    }

    @JsOverlay
    public final boolean hasClassName(String className) {
        className = Element.trimClassName(className);
        int idx = Element.indexOfName(this.getClassName(), className);
        return idx != -1;
    }

    @JsOverlay
    public final boolean hasTagName(String tagName) {
        assert (tagName != null) : "tagName must not be null";
        return tagName.equalsIgnoreCase(this.getTagName());
    }

    public final native void removeAttribute(String var1);

    @JsOverlay
    public final boolean removeClassName(String className) {
        className = Element.trimClassName(className);
        String oldStyle = this.getClassName();
        int idx = Element.indexOfName(oldStyle, className);
        if (idx != -1) {
            String begin = oldStyle.substring(0, idx).trim();
            String end = oldStyle.substring(idx + className.length()).trim();
            String newClassName = begin.length() == 0 ? end : (end.length() == 0 ? begin : begin + " " + end);
            this.setClassName(newClassName);
            return true;
        }
        return false;
    }

    @JsOverlay
    static int indexOfName(String nameList, String name) {
        int lastPos;
        int last;
        int idx = nameList.indexOf(name);
        while (idx != -1 && (idx != 0 && nameList.charAt(idx - 1) != ' ' || (last = idx + name.length()) != (lastPos = nameList.length()) && (last >= lastPos || nameList.charAt(last) != ' '))) {
            idx = nameList.indexOf(name, idx + 1);
        }
        return idx;
    }

    @JsOverlay
    private static String trimClassName(String className) {
        assert (className != null) : "Unexpectedly null class name";
        className = className.trim();
        assert (!className.isEmpty()) : "Unexpectedly empty class name";
        return className;
    }

    @JsOverlay
    public final void toggleClassName(String className) {
        boolean added = this.addClassName(className);
        if (!added) {
            this.removeClassName(className);
        }
    }

    @JsOverlay
    public final void replaceClassName(String oldClassName, String newClassName) {
        this.removeClassName(oldClassName);
        this.addClassName(newClassName);
    }

    @JsOverlay
    public final void scrollIntoView() {
        HTMLElement e = (HTMLElement)Js.uncheckedCast(this);
        double left = e.offsetLeft;
        double top = e.offsetTop;
        double width = e.offsetWidth;
        double height = e.offsetHeight;
        if (e.parentNode != e.offsetParent && e.parentNode.nodeType == 1) {
            left -= (double)((HTMLElement)Js.uncheckedCast((Object)e.parentNode)).offsetLeft;
            top -= (double)((HTMLElement)Js.uncheckedCast((Object)e.parentNode)).offsetTop;
        }
        elemental2.dom.Node cur = e.parentNode;
        while (cur != null && cur.nodeType == 1) {
            HTMLElement curEl = (HTMLElement)Js.uncheckedCast(cur);
            if (left < curEl.scrollLeft) {
                curEl.scrollLeft = left;
            }
            if (left + width > curEl.scrollLeft + (double)curEl.clientWidth) {
                curEl.scrollLeft = left + width - (double)curEl.clientWidth;
            }
            if (top < curEl.scrollTop) {
                curEl.scrollTop = top;
            }
            if (top + height > curEl.scrollTop + (double)curEl.clientHeight) {
                curEl.scrollTop = top + height - (double)curEl.clientHeight;
            }
            double offsetLeft = curEl.offsetLeft;
            double offsetTop = curEl.offsetTop;
            if (curEl.parentNode != curEl.offsetParent && curEl.parentNode.nodeType == 1) {
                offsetLeft -= (double)((HTMLElement)Js.uncheckedCast((Object)curEl.parentNode)).offsetLeft;
                offsetTop -= (double)((HTMLElement)Js.uncheckedCast((Object)curEl.parentNode)).offsetTop;
            }
            left += offsetLeft - curEl.scrollLeft;
            top += offsetTop - curEl.scrollTop;
            cur = curEl.parentNode;
        }
    }

    public final native void setAttribute(String var1, String var2);

    @JsOverlay
    public final void setClassName(String className) {
        ((HTMLElement)Js.uncheckedCast((Object)this)).className = className == null ? "" : className;
    }

    @JsProperty
    public final native void setDir(String var1);

    @JsOverlay
    public final void setDraggable(String draggable) {
        ((HTMLElement)Js.uncheckedCast((Object)this)).draggable = DRAGGABLE_TRUE.equalsIgnoreCase(draggable);
    }

    @JsProperty
    public final native void setId(String var1);

    @JsOverlay
    public final void setInnerHTML(@IsSafeHtml String html) {
        ((HTMLElement)Js.uncheckedCast((Object)this)).innerHTML = html == null ? "" : html;
    }

    @JsOverlay
    public final void setInnerSafeHtml(SafeHtml html) {
        this.setInnerHTML(html.asString());
    }

    @JsOverlay
    public final void setInnerText(String text) {
        ((HTMLElement)Js.uncheckedCast((Object)this)).textContent = text != null ? text : "";
    }

    @JsProperty
    public final native void setLang(String var1);

    @JsOverlay
    public final void setPropertyBoolean(String name, boolean value) {
        Js.asPropertyMap(this).set(name, value);
    }

    @JsOverlay
    public final void setPropertyDouble(String name, double value) {
        Js.asPropertyMap(this).set(name, value);
    }

    @JsOverlay
    public final void setPropertyInt(String name, int value) {
        Js.asPropertyMap(this).set(name, value);
    }

    @JsOverlay
    public final void setPropertyJSO(String name, JavaScriptObject value) {
        this.setPropertyObject(name, value);
    }

    @JsOverlay
    public final void setPropertyObject(String name, Object value) {
        Js.asPropertyMap(this).set(name, value);
    }

    @JsOverlay
    public final void setPropertyString(String name, String value) {
        Js.asPropertyMap(this).set(name, value);
    }

    @JsOverlay
    public final void setScrollLeft(int scrollLeft) {
        if (UserAgentHolder.IS_SAFARI && !this.hasTagName("body") && !this.hasTagName("HTML") && this.isRTLSafari()) {
            scrollLeft += this.getScrollWidth() - this.getClientWidth();
        }
        ((HTMLElement)Js.uncheckedCast((Object)this)).scrollLeft = scrollLeft;
    }

    @JsProperty
    public final native void setScrollTop(int var1);

    @JsProperty
    public final native void setTabIndex(int var1);

    @JsOverlay
    public final void setTitle(String title) {
        ((HTMLElement)Js.uncheckedCast((Object)this)).title = title == null ? "" : title;
    }

    @JsOverlay
    private final double getSubPixelClientHeight() {
        return ((elemental2.dom.Element)Js.uncheckedCast((Object)this)).clientHeight;
    }

    @JsOverlay
    private final double getSubPixelClientWidth() {
        return ((elemental2.dom.Element)Js.uncheckedCast((Object)this)).clientWidth;
    }

    @JsOverlay
    private final double getSubPixelOffsetHeight() {
        double value = ((HTMLElement)Js.uncheckedCast((Object)this)).offsetHeight;
        return Js.isTruthy(value) ? value : 0.0;
    }

    @JsOverlay
    private final double getSubPixelOffsetLeft() {
        double value = ((HTMLElement)Js.uncheckedCast((Object)this)).offsetLeft;
        return Js.isTruthy(value) ? value : 0.0;
    }

    @JsOverlay
    private final double getSubPixelOffsetTop() {
        double value = ((HTMLElement)Js.uncheckedCast((Object)this)).offsetTop;
        return Js.isTruthy(value) ? value : 0.0;
    }

    @JsOverlay
    private final double getSubPixelOffsetWidth() {
        double value = ((HTMLElement)Js.uncheckedCast((Object)this)).offsetWidth;
        return Js.isTruthy(value) ? value : 0.0;
    }

    @JsOverlay
    private final double getSubPixelScrollHeight() {
        double value = ((elemental2.dom.Element)Js.uncheckedCast((Object)this)).scrollHeight;
        return Js.isTruthy(value) ? value : 0.0;
    }

    @JsOverlay
    private final double getSubPixelScrollTop() {
        double value = ((elemental2.dom.Element)Js.uncheckedCast((Object)this)).scrollTop;
        return Js.isTruthy(value) ? value : 0.0;
    }

    @JsOverlay
    private final double getSubPixelScrollWidth() {
        double value = ((elemental2.dom.Element)Js.uncheckedCast((Object)this)).scrollWidth;
        return Js.isTruthy(value) ? value : 0.0;
    }

    @JsOverlay
    private boolean isRTLSafari() {
        HTMLElement e = (HTMLElement)Js.uncheckedCast(this);
        ViewCSS defaultView = (ViewCSS)Js.uncheckedCast(((JsPropertyMap)Js.uncheckedCast(e.ownerDocument)).get("defaultView"));
        return Objects.equals(defaultView.getComputedStyle((elemental2.dom.Element)e, (String)"").direction, "rtl");
    }

    private static class UserAgentHolder {
        private static final boolean IS_SAFARI = "safari".equals(System.getProperty("user.agent"));

        private UserAgentHolder() {
        }
    }
}

