/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.dom.client;

import elemental2.dom.Event;
import elemental2.dom.EventInit;
import elemental2.dom.EventTarget;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDocument;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.KeyboardEvent;
import elemental2.dom.KeyboardEventInit;
import elemental2.dom.MouseEvent;
import elemental2.dom.MouseEventInit;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;
import org.gwtproject.dom.client.AnchorElement;
import org.gwtproject.dom.client.AreaElement;
import org.gwtproject.dom.client.AudioElement;
import org.gwtproject.dom.client.BRElement;
import org.gwtproject.dom.client.BaseElement;
import org.gwtproject.dom.client.BodyElement;
import org.gwtproject.dom.client.ButtonElement;
import org.gwtproject.dom.client.CanvasElement;
import org.gwtproject.dom.client.DListElement;
import org.gwtproject.dom.client.DivElement;
import org.gwtproject.dom.client.Element;
import org.gwtproject.dom.client.FieldSetElement;
import org.gwtproject.dom.client.FormElement;
import org.gwtproject.dom.client.FrameElement;
import org.gwtproject.dom.client.FrameSetElement;
import org.gwtproject.dom.client.HRElement;
import org.gwtproject.dom.client.HeadElement;
import org.gwtproject.dom.client.HeadingElement;
import org.gwtproject.dom.client.IFrameElement;
import org.gwtproject.dom.client.ImageElement;
import org.gwtproject.dom.client.InputElement;
import org.gwtproject.dom.client.LIElement;
import org.gwtproject.dom.client.LabelElement;
import org.gwtproject.dom.client.LegendElement;
import org.gwtproject.dom.client.LinkElement;
import org.gwtproject.dom.client.MapElement;
import org.gwtproject.dom.client.MetaElement;
import org.gwtproject.dom.client.ModElement;
import org.gwtproject.dom.client.NativeEvent;
import org.gwtproject.dom.client.Node;
import org.gwtproject.dom.client.NodeList;
import org.gwtproject.dom.client.OListElement;
import org.gwtproject.dom.client.ObjectElement;
import org.gwtproject.dom.client.OptGroupElement;
import org.gwtproject.dom.client.OptionElement;
import org.gwtproject.dom.client.ParagraphElement;
import org.gwtproject.dom.client.ParamElement;
import org.gwtproject.dom.client.PreElement;
import org.gwtproject.dom.client.QuoteElement;
import org.gwtproject.dom.client.ScriptElement;
import org.gwtproject.dom.client.SelectElement;
import org.gwtproject.dom.client.SourceElement;
import org.gwtproject.dom.client.SpanElement;
import org.gwtproject.dom.client.StyleElement;
import org.gwtproject.dom.client.TableCaptionElement;
import org.gwtproject.dom.client.TableCellElement;
import org.gwtproject.dom.client.TableColElement;
import org.gwtproject.dom.client.TableElement;
import org.gwtproject.dom.client.TableRowElement;
import org.gwtproject.dom.client.TableSectionElement;
import org.gwtproject.dom.client.Text;
import org.gwtproject.dom.client.TextAreaElement;
import org.gwtproject.dom.client.TitleElement;
import org.gwtproject.dom.client.UListElement;
import org.gwtproject.dom.client.VideoElement;

@JsType(isNative=true, name="Object", namespace="<global>")
public class Document
extends Node {
    @JsProperty(name="gwt_uid")
    private double gwtUid;

    @JsOverlay
    public static Document get() {
        if (DocumentHolder.doc == null) {
            if ("undefined".equals(Js.typeof(DocumentHolder.nativeGet$doc()))) {
                DocumentHolder.doc = DocumentHolder.nativeGetDocument();
            } else {
                DocumentHolder.doc = DocumentHolder.nativeGet$doc();
            }
        }
        return DocumentHolder.doc;
    }

    protected Document() {
    }

    @JsOverlay
    public final AnchorElement createAnchorElement() {
        return (AnchorElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("a")));
    }

    @JsOverlay
    public final AreaElement createAreaElement() {
        return (AreaElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("area")));
    }

    @JsOverlay
    public final AudioElement createAudioElement() {
        return (AudioElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("audio")));
    }

    @JsOverlay
    public final BaseElement createBaseElement() {
        return (BaseElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("base")));
    }

    @JsOverlay
    public final QuoteElement createBlockQuoteElement() {
        return (QuoteElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("blockquote")));
    }

    @JsOverlay
    public final NativeEvent createBlurEvent() {
        return this.createHtmlEvent("blur", false, false);
    }

    @JsOverlay
    public final BRElement createBRElement() {
        return (BRElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("br")));
    }

    @JsOverlay
    public final InputElement createButtonInputElement() {
        return this.createInputElement("button");
    }

    @JsOverlay
    public final CanvasElement createCanvasElement() {
        return (CanvasElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("canvas")));
    }

    @JsOverlay
    public final TableCaptionElement createCaptionElement() {
        return (TableCaptionElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("caption")));
    }

    @JsOverlay
    public final NativeEvent createChangeEvent() {
        return this.createHtmlEvent("change", false, true);
    }

    @JsOverlay
    public final InputElement createCheckInputElement() {
        HTMLInputElement e = (HTMLInputElement)((HTMLDocument)Js.uncheckedCast(this)).createElement("INPUT");
        e.type = "checkbox";
        e.value = "on";
        return (InputElement)Js.uncheckedCast(e);
    }

    @JsOverlay
    public final NativeEvent createClickEvent(int detail, int screenX, int screenY, int clientX, int clientY, boolean ctrlKey, boolean altKey, boolean shiftKey, boolean metaKey) {
        return this.createMouseEvent("click", true, true, detail, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, 1, null);
    }

    @JsOverlay
    public final TableColElement createColElement() {
        return (TableColElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("col")));
    }

    @JsOverlay
    public final TableColElement createColGroupElement() {
        return (TableColElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("colgroup")));
    }

    @JsOverlay
    public final NativeEvent createContextMenuEvent() {
        return this.createHtmlEvent("contextmenu", true, true);
    }

    @JsOverlay
    public final NativeEvent createDblClickEvent(int detail, int screenX, int screenY, int clientX, int clientY, boolean ctrlKey, boolean altKey, boolean shiftKey, boolean metaKey) {
        return this.createMouseEvent("dblclick", true, true, detail, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, 1, null);
    }

    @JsOverlay
    public final ModElement createDelElement() {
        return (ModElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("del")));
    }

    @JsOverlay
    public final DivElement createDivElement() {
        return (DivElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("div")));
    }

    @JsOverlay
    public final DListElement createDLElement() {
        return (DListElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("dl")));
    }

    @JsOverlay
    public final Element createElement(String tagName) {
        return (Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement(tagName));
    }

    @JsOverlay
    public final NativeEvent createErrorEvent() {
        return this.createHtmlEvent("error", false, false);
    }

    @JsOverlay
    public final FieldSetElement createFieldSetElement() {
        return (FieldSetElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("fieldset")));
    }

    @JsOverlay
    public final InputElement createFileInputElement() {
        return this.createInputElement("file");
    }

    @JsOverlay
    public final NativeEvent createFocusEvent() {
        return this.createHtmlEvent("focus", false, false);
    }

    @JsOverlay
    public final FormElement createFormElement() {
        return (FormElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("form")));
    }

    @JsOverlay
    public final FrameElement createFrameElement() {
        return (FrameElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("frame")));
    }

    @JsOverlay
    public final FrameSetElement createFrameSetElement() {
        return (FrameSetElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("frameset")));
    }

    @JsOverlay
    public final HeadElement createHeadElement() {
        return (HeadElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("head")));
    }

    @JsOverlay
    public final HeadingElement createHElement(int n) {
        assert (n >= 1 && n <= 6);
        return (HeadingElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("h" + n)));
    }

    @JsOverlay
    public final InputElement createHiddenInputElement() {
        return this.createInputElement("hidden");
    }

    @JsOverlay
    public final HRElement createHRElement() {
        return (HRElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("hr")));
    }

    @JsOverlay
    @Deprecated
    public final NativeEvent createHtmlEvent(String type, boolean canBubble, boolean cancelable) {
        EventInit details = EventInit.create();
        details.setBubbles(canBubble);
        details.setCancelable(cancelable);
        Event evt = new Event(type, details);
        return (NativeEvent)((Object)evt);
    }

    @JsOverlay
    public final IFrameElement createIFrameElement() {
        return (IFrameElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("iframe")));
    }

    @JsOverlay
    public final ImageElement createImageElement() {
        return (ImageElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("img")));
    }

    @JsOverlay
    public final InputElement createImageInputElement() {
        return this.createInputElement("image");
    }

    @JsOverlay
    public final NativeEvent createInputEvent() {
        return this.createHtmlEvent("input", true, false);
    }

    @JsOverlay
    public final ModElement createInsElement() {
        return (ModElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("ins")));
    }

    @JsOverlay
    public final NativeEvent createKeyCodeEvent(String type, boolean ctrlKey, boolean altKey, boolean shiftKey, boolean metaKey, int keyCode) {
        KeyboardEventInit init = KeyboardEventInit.create();
        init.setCtrlKey(ctrlKey);
        init.setAltKey(altKey);
        init.setShiftKey(shiftKey);
        init.setMetaKey(metaKey);
        init.setBubbles(true);
        ((JsPropertyMap)Js.uncheckedCast(init)).set("keyCode", keyCode);
        KeyboardEvent event = new KeyboardEvent(type, init);
        return (NativeEvent)Js.uncheckedCast(event);
    }

    @JsOverlay
    public final NativeEvent createKeyDownEvent(boolean ctrlKey, boolean altKey, boolean shiftKey, boolean metaKey, int keyCode) {
        return this.createKeyCodeEvent("keydown", ctrlKey, altKey, shiftKey, metaKey, keyCode);
    }

    @JsOverlay
    @Deprecated
    public final NativeEvent createKeyPressEvent(boolean ctrlKey, boolean altKey, boolean shiftKey, boolean metaKey, int charCode) {
        KeyboardEventInit init = KeyboardEventInit.create();
        init.setCtrlKey(ctrlKey);
        init.setAltKey(altKey);
        init.setShiftKey(shiftKey);
        init.setMetaKey(metaKey);
        init.setBubbles(true);
        ((JsPropertyMap)Js.uncheckedCast(init)).set("charCode", charCode);
        KeyboardEvent event = new KeyboardEvent("keypress", init);
        return (NativeEvent)Js.uncheckedCast(event);
    }

    @JsOverlay
    public final NativeEvent createKeyUpEvent(boolean ctrlKey, boolean altKey, boolean shiftKey, boolean metaKey, int keyCode) {
        return this.createKeyCodeEvent("keyup", ctrlKey, altKey, shiftKey, metaKey, keyCode);
    }

    @JsOverlay
    public final LabelElement createLabelElement() {
        return (LabelElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("label")));
    }

    @JsOverlay
    public final LegendElement createLegendElement() {
        return (LegendElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("legend")));
    }

    @JsOverlay
    public final LIElement createLIElement() {
        return (LIElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("li")));
    }

    @JsOverlay
    public final LinkElement createLinkElement() {
        return (LinkElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("link")));
    }

    @JsOverlay
    public final NativeEvent createLoadEvent() {
        return this.createHtmlEvent("load", false, false);
    }

    @JsOverlay
    public final MapElement createMapElement() {
        return (MapElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("map")));
    }

    @JsOverlay
    public final MetaElement createMetaElement() {
        return (MetaElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("meta")));
    }

    @JsOverlay
    public final NativeEvent createMouseDownEvent(int detail, int screenX, int screenY, int clientX, int clientY, boolean ctrlKey, boolean altKey, boolean shiftKey, boolean metaKey, int button) {
        return this.createMouseEvent("mousedown", true, true, detail, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, button, null);
    }

    @JsOverlay
    public final NativeEvent createMouseEvent(String type, boolean canBubble, boolean cancelable, int detail, int screenX, int screenY, int clientX, int clientY, boolean ctrlKey, boolean altKey, boolean shiftKey, boolean metaKey, int button, Element relatedTarget) {
        int button1 = button;
        button1 = button1 == 1 ? 0 : (button1 == 4 ? 1 : 2);
        MouseEventInit init = MouseEventInit.create();
        init.setButton(button1);
        init.setBubbles(canBubble);
        init.setCancelable(cancelable);
        init.setDetail(detail);
        init.setScreenX(screenX);
        init.setScreenY(screenY);
        init.setClientX(clientX);
        init.setClientY(clientY);
        init.setCtrlKey(ctrlKey);
        init.setAltKey(altKey);
        init.setShiftKey(shiftKey);
        init.setMetaKey(metaKey);
        init.setRelatedTarget((EventTarget)Js.uncheckedCast(relatedTarget));
        return (NativeEvent)Js.uncheckedCast(new MouseEvent(type, init));
    }

    @JsOverlay
    public final NativeEvent createMouseMoveEvent(int detail, int screenX, int screenY, int clientX, int clientY, boolean ctrlKey, boolean altKey, boolean shiftKey, boolean metaKey, int button) {
        return this.createMouseEvent("mousemove", true, true, detail, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, button, null);
    }

    @JsOverlay
    public final NativeEvent createMouseOutEvent(int detail, int screenX, int screenY, int clientX, int clientY, boolean ctrlKey, boolean altKey, boolean shiftKey, boolean metaKey, int button, Element relatedTarget) {
        return this.createMouseEvent("mouseout", true, true, detail, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, button, relatedTarget);
    }

    @JsOverlay
    public final NativeEvent createMouseOverEvent(int detail, int screenX, int screenY, int clientX, int clientY, boolean ctrlKey, boolean altKey, boolean shiftKey, boolean metaKey, int button, Element relatedTarget) {
        return this.createMouseEvent("mouseover", true, true, detail, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, button, relatedTarget);
    }

    @JsOverlay
    public final NativeEvent createMouseUpEvent(int detail, int screenX, int screenY, int clientX, int clientY, boolean ctrlKey, boolean altKey, boolean shiftKey, boolean metaKey, int button) {
        return this.createMouseEvent("mouseup", true, true, detail, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, button, null);
    }

    @JsOverlay
    public final ObjectElement createObjectElement() {
        return (ObjectElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("object")));
    }

    @JsOverlay
    public final OListElement createOLElement() {
        return (OListElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("ol")));
    }

    @JsOverlay
    public final OptGroupElement createOptGroupElement() {
        return (OptGroupElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("optgroup")));
    }

    @JsOverlay
    public final OptionElement createOptionElement() {
        return (OptionElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("option")));
    }

    @JsOverlay
    public final ParamElement createParamElement() {
        return (ParamElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("param")));
    }

    @JsOverlay
    public final InputElement createPasswordInputElement() {
        return this.createInputElement("password");
    }

    @JsOverlay
    public final ParagraphElement createPElement() {
        return (ParagraphElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("p")));
    }

    @JsOverlay
    public final PreElement createPreElement() {
        return (PreElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("pre")));
    }

    @JsOverlay
    public final ButtonElement createPushButtonElement() {
        return this.createButtonElement("button");
    }

    @JsOverlay
    public final QuoteElement createQElement() {
        return (QuoteElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("q")));
    }

    @JsOverlay
    public final InputElement createRadioInputElement(String name) {
        return this.createInputRadioElement(name);
    }

    @JsOverlay
    public final ButtonElement createResetButtonElement() {
        return this.createButtonElement("reset");
    }

    @JsOverlay
    public final InputElement createResetInputElement() {
        return this.createInputElement("reset");
    }

    @JsOverlay
    public final ScriptElement createScriptElement() {
        return (ScriptElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("script")));
    }

    @JsOverlay
    public final ScriptElement createScriptElement(String source) {
        ScriptElement elem = (ScriptElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("script")));
        elem.setText(source);
        return elem;
    }

    @JsOverlay
    public final NativeEvent createScrollEvent() {
        return this.createHtmlEvent("scroll", false, false);
    }

    @JsOverlay
    public final SelectElement createSelectElement() {
        return (SelectElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("select")));
    }

    @JsOverlay
    public final SourceElement createSourceElement() {
        return (SourceElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("source")));
    }

    @JsOverlay
    public final SpanElement createSpanElement() {
        return (SpanElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("span")));
    }

    @JsOverlay
    public final StyleElement createStyleElement() {
        return (StyleElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("style")));
    }

    @JsOverlay
    public final ButtonElement createSubmitButtonElement() {
        return this.createButtonElement("submit");
    }

    @JsOverlay
    public final InputElement createSubmitInputElement() {
        return this.createInputElement("submit");
    }

    @JsOverlay
    public final TableElement createTableElement() {
        return (TableElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("table")));
    }

    @JsOverlay
    public final TableSectionElement createTBodyElement() {
        return (TableSectionElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("tbody")));
    }

    @JsOverlay
    public final TableCellElement createTDElement() {
        return (TableCellElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("td")));
    }

    @JsOverlay
    public final TextAreaElement createTextAreaElement() {
        return (TextAreaElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("textarea")));
    }

    @JsOverlay
    public final InputElement createTextInputElement() {
        return this.createInputElement("text");
    }

    public final native Text createTextNode(String var1);

    @JsOverlay
    public final TableSectionElement createTFootElement() {
        return (TableSectionElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("tfoot")));
    }

    @JsOverlay
    public final TableSectionElement createTHeadElement() {
        return (TableSectionElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("thead")));
    }

    @JsOverlay
    public final TableCellElement createTHElement() {
        return (TableCellElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("th")));
    }

    @JsOverlay
    public final TitleElement createTitleElement() {
        return (TitleElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("title")));
    }

    @JsOverlay
    public final TableRowElement createTRElement() {
        return (TableRowElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("tr")));
    }

    @JsOverlay
    public final UListElement createULElement() {
        return (UListElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("ul")));
    }

    @JsOverlay
    public final String createUniqueId() {
        if (Js.isFalsy(this.gwtUid)) {
            this.gwtUid = 1.0;
        }
        double d = this.gwtUid;
        this.gwtUid = d + 1.0;
        return "gwt-uid-" + d;
    }

    @JsOverlay
    public final VideoElement createVideoElement() {
        return (VideoElement)((Element)((Object)((HTMLDocument)Js.uncheckedCast(this)).createElement("video")));
    }

    @JsOverlay
    public final void enableScrolling(boolean enable) {
        this.getViewportElement().getStyle().setProperty("overflow", enable ? "auto" : "hidden");
    }

    @JsProperty
    public final native BodyElement getBody();

    @JsOverlay
    public final int getBodyOffsetLeft() {
        return ((HTMLDocument)Js.uncheckedCast((Object)this)).documentElement.clientLeft;
    }

    @JsOverlay
    public final int getBodyOffsetTop() {
        return ((HTMLDocument)Js.uncheckedCast((Object)this)).documentElement.clientTop;
    }

    @JsOverlay
    public final int getClientHeight() {
        return this.getViewportElement().getClientHeight();
    }

    @JsOverlay
    public final int getClientWidth() {
        return this.getViewportElement().getClientWidth();
    }

    @JsProperty
    public final native String getCompatMode();

    @JsProperty
    public final native Element getDocumentElement();

    @JsProperty
    public final native String getDomain();

    public final native Element getElementById(String var1);

    public final native NodeList<Element> getElementsByTagName(String var1);

    @JsProperty
    public final native HeadElement getHead();

    @JsProperty
    public final native String getReferrer();

    @JsOverlay
    public final int getScrollHeight() {
        return this.getViewportElement().getScrollHeight();
    }

    @JsOverlay
    public final int getScrollLeft() {
        return this.ensureDocumentScrollingElement().getScrollLeft();
    }

    @JsOverlay
    public final int getScrollTop() {
        return this.ensureDocumentScrollingElement().getScrollTop();
    }

    @JsOverlay
    public final int getScrollWidth() {
        return this.getViewportElement().getScrollWidth();
    }

    @JsProperty
    public final native String getTitle();

    @JsProperty
    public final native String getURL();

    public final native void importNode(Node var1, boolean var2);

    @JsOverlay
    public final boolean isCSS1Compat() {
        return this.getCompatMode().equals("CSS1Compat");
    }

    @JsOverlay
    public final void setScrollLeft(int left) {
        this.ensureDocumentScrollingElement().setScrollLeft(left);
    }

    @JsOverlay
    public final void setScrollTop(int top) {
        this.ensureDocumentScrollingElement().setScrollTop(top);
    }

    @JsProperty
    public final native void setTitle(String var1);

    @JsOverlay
    private Element getViewportElement() {
        return this.isCSS1Compat() ? this.getDocumentElement() : this.getBody();
    }

    @JsOverlay
    private ButtonElement createButtonElement(String type) {
        HTMLButtonElement e = (HTMLButtonElement)((HTMLDocument)Js.uncheckedCast(this)).createElement("BUTTON");
        e.type = type;
        return (ButtonElement)Js.uncheckedCast(e);
    }

    @JsOverlay
    private InputElement createInputElement(String type) {
        HTMLInputElement e = (HTMLInputElement)((HTMLDocument)((Object)this)).createElement("INPUT");
        e.type = type;
        return (InputElement)Js.uncheckedCast(e);
    }

    @JsOverlay
    private InputElement createInputRadioElement(String name) {
        HTMLInputElement elem = (HTMLInputElement)((HTMLDocument)((Object)this)).createElement("INPUT");
        elem.type = "radio";
        elem.name = name;
        elem.value = "on";
        return (InputElement)Js.uncheckedCast(elem);
    }

    @JsOverlay
    private Element ensureDocumentScrollingElement() {
        Element scrollingElement = (Element)Js.uncheckedCast(((HTMLDocument)Js.uncheckedCast((Object)this)).scrollingElement);
        if (scrollingElement != null) {
            return scrollingElement;
        }
        scrollingElement = this.getViewportElement();
        return scrollingElement != null ? scrollingElement : this.getDocumentElement();
    }

    private static class DocumentHolder {
        private static Document doc;

        private DocumentHolder() {
        }

        @JsProperty(name="document", namespace="<global>")
        private static native Document nativeGetDocument();

        @JsProperty(name="$doc", namespace="<window>")
        private static native Document nativeGet$doc();
    }
}

