/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.canvas.dom.client;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import org.gwtproject.canvas.dom.client.CanvasPixelArray;
import org.gwtproject.core.client.JavaScriptObject;

@JsType(isNative=true, name="Object", namespace="<global>")
public class ImageData
extends JavaScriptObject {
    @JsOverlay
    private static final int NUM_COLORS = 4;
    @JsOverlay
    private static final int OFFSET_RED = 0;
    @JsOverlay
    private static final int OFFSET_GREEN = 1;
    @JsOverlay
    private static final int OFFSET_BLUE = 2;
    @JsOverlay
    private static final int OFFSET_ALPHA = 3;

    protected ImageData() {
    }

    @JsOverlay
    public final int getAlphaAt(int x, int y) {
        return this.getColorAt(x, y, 3);
    }

    @JsOverlay
    public final int getBlueAt(int x, int y) {
        return this.getColorAt(x, y, 2);
    }

    @JsProperty
    public final native CanvasPixelArray getData();

    @JsOverlay
    public final int getGreenAt(int x, int y) {
        return this.getColorAt(x, y, 1);
    }

    @JsProperty
    public final native int getHeight();

    @JsOverlay
    public final int getRedAt(int x, int y) {
        return this.getColorAt(x, y, 0);
    }

    @JsProperty
    public final native int getWidth();

    @JsOverlay
    public final void setAlphaAt(int alpha, int x, int y) {
        this.setColorAt(alpha, x, y, 3);
    }

    @JsOverlay
    public final void setBlueAt(int blue, int x, int y) {
        this.setColorAt(blue, x, y, 2);
    }

    @JsOverlay
    public final void setGreenAt(int green, int x, int y) {
        this.setColorAt(green, x, y, 1);
    }

    @JsOverlay
    public final void setRedAt(int red, int x, int y) {
        this.setColorAt(red, x, y, 0);
    }

    @JsOverlay
    private int getColorAt(int x, int y, int offset) {
        int index = 4 * (x + y * this.getWidth()) + offset;
        if (index < 0 || index >= this.getData().getLength()) {
            return 0;
        }
        return this.getData().get(index);
    }

    @JsOverlay
    private void setColorAt(int color, int x, int y, int offset) {
        int index = 4 * (x + y * this.getWidth()) + offset;
        this.getData().set(index, color);
    }
}

