/*
 * Decompiled with CFR 0.152.
 */
package jsinterop.base;

import javaemul.internal.annotations.DoNotAutobox;
import javaemul.internal.annotations.HasNoSideEffects;
import javaemul.internal.annotations.UncheckedCast;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsProperty;
import jsinterop.base.Any;
import jsinterop.base.InternalJsUtil;
import jsinterop.base.InternalPreconditions;
import jsinterop.base.JsArrayLike;
import jsinterop.base.JsConstructorFn;
import jsinterop.base.JsPropertyMap;

public final class Js {
    @JsProperty(namespace="<window>", name="undefined")
    public static native Object undefined();

    @JsProperty(namespace="<window>", name="arguments")
    public static native JsArrayLike<Object> arguments();

    @JsProperty(namespace="<window>", name="debugger")
    public static native void debugger();

    @JsMethod(namespace="<window>")
    @HasNoSideEffects
    public static native String typeof(Object var0);

    public static native JsPropertyMap<Object> global();

    public static <T> JsConstructorFn<T> asConstructorFn(Class<T> clazz) {
        JsConstructorFn<T> fn = InternalJsUtil.toCtor(clazz);
        InternalPreconditions.checkType(fn != null);
        return fn;
    }

    public static Any asAny(@DoNotAutobox Object obj) {
        return (Any)Js.uncheckedCast(obj);
    }

    public static JsPropertyMap<Object> asPropertyMap(Object obj) {
        return (JsPropertyMap)Js.uncheckedCast(obj);
    }

    public static JsArrayLike<Object> asArrayLike(Object obj) {
        InternalPreconditions.checkType(obj == null || InternalJsUtil.hasLength(obj));
        return (JsArrayLike)Js.uncheckedCast(obj);
    }

    public static Any[] asArray(Object obj) {
        InternalPreconditions.checkType(obj instanceof Any[]);
        return (Any[])Js.uncheckedCast(obj);
    }

    public static String asString(Object obj) {
        InternalPreconditions.checkType(Js.typeof(obj) == "string");
        return (String)Js.uncheckedCast(obj);
    }

    public static boolean asBoolean(Object obj) {
        InternalPreconditions.checkType(Js.typeof(obj) == "boolean");
        return InternalJsUtil.asBoolean(obj);
    }

    public static double asDouble(Object obj) {
        InternalPreconditions.checkType(Js.typeof(obj) == "number");
        return InternalJsUtil.asDouble(obj);
    }

    public static float asFloat(Object obj) {
        return (float)Js.asDouble(obj);
    }

    public static long asLong(Object obj) {
        InternalPreconditions.checkType(InternalJsUtil.isLong(obj));
        return InternalJsUtil.asLong(obj);
    }

    public static int asInt(Object obj) {
        InternalPreconditions.checkType(InternalJsUtil.isInt(obj));
        return InternalJsUtil.asInt(obj);
    }

    public static short asShort(Object obj) {
        int num = Js.asInt(obj);
        InternalPreconditions.checkType(num == (short)num);
        return InternalJsUtil.asShort(obj);
    }

    public static char asChar(Object obj) {
        int num = Js.asInt(obj);
        InternalPreconditions.checkType(num == (char)num);
        return InternalJsUtil.asChar(obj);
    }

    public static byte asByte(Object obj) {
        int num = Js.asInt(obj);
        InternalPreconditions.checkType(num == (byte)num);
        return InternalJsUtil.asByte(obj);
    }

    public static <T> T cast(@DoNotAutobox Object obj) {
        return (T)obj;
    }

    @UncheckedCast
    public static <T> T uncheckedCast(@DoNotAutobox Object obj) {
        return (T)obj;
    }

    public static boolean isTruthy(@DoNotAutobox Object obj) {
        return !Js.isFalsy(obj);
    }

    @HasNoSideEffects
    public static native boolean isFalsy(@DoNotAutobox Object var0);

    @HasNoSideEffects
    public static native boolean isTripleEqual(@DoNotAutobox Object var0, @DoNotAutobox Object var1);

    public static native double coerceToDouble(Object var0);

    public static int coerceToInt(@DoNotAutobox Object d) {
        return InternalJsUtil.asInt(d) | 0;
    }

    private Js() {
    }
}

