/*
 * Decompiled with CFR 0.152.
 */
package jsinterop.base;

public final class InternalPreconditions {
    private static final boolean IS_TYPE_CHECKED = System.getProperty("jsinterop.checks").equals("ENABLED");
    private static final boolean IS_ASSERTED = System.getProperty("jre.checkedMode").equals("ENABLED");

    public static void checkType(boolean expression) {
        if (IS_TYPE_CHECKED) {
            InternalPreconditions.checkCriticalType(expression);
        } else if (IS_ASSERTED) {
            try {
                InternalPreconditions.checkCriticalType(expression);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static void checkCriticalType(boolean expression) {
        if (!expression) {
            throw new ClassCastException();
        }
    }

    private InternalPreconditions() {
    }
}

