/*
 * Decompiled with CFR 0.152.
 */
package io.crysknife.validation;

import io.crysknife.exception.UnableToCompleteException;
import io.crysknife.generator.context.IOCContext;
import io.crysknife.util.Utils;
import io.crysknife.validation.Check;
import io.crysknife.validation.Validator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

public class InjectionPointValidator
extends Validator<VariableElement> {
    private Validator fieldValidator;
    private Set<Check> checks = new HashSet<Check>(){
        {
            this.add(new Check<VariableElement>(){

                @Override
                public void check(VariableElement variableElement) throws UnableToCompleteException {
                    if (variableElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                        this.log(variableElement, "Field injection point must not be abstract", new String[0]);
                    }
                }
            });
            this.add(new Check<VariableElement>(){

                @Override
                public void check(VariableElement variableElement) throws UnableToCompleteException {
                    Named named;
                    List<AnnotationMirror> qualifiers = Utils.getAllElementQualifierAnnotations(this.context, variableElement);
                    if (qualifiers.size() > 1) {
                        this.log(variableElement, "Injection point must be annotated with only one @Qualifier, but there is " + qualifiers.size(), new String[0]);
                    }
                    if ((named = variableElement.getAnnotation(Named.class)) != null && !qualifiers.isEmpty()) {
                        this.log(variableElement, "Injection point must be annotated with @Named or @Qualifier, but not both at the same time", new String[0]);
                    }
                }
            });
        }
    };

    public InjectionPointValidator(IOCContext context, Element parent) {
        super(context);
        if (parent.getKind().equals((Object)ElementKind.CLASS)) {
            this.fieldValidator = new InjectionPointFieldValidator(context, this);
        } else if (parent.getKind().equals((Object)ElementKind.CONSTRUCTOR)) {
            this.fieldValidator = new InjectionPointConstructorValidator(context, this);
        }
    }

    @Override
    public void validate(VariableElement variableElement) throws UnableToCompleteException {
        this.fieldValidator.validate(variableElement);
    }

    private static class InjectionPointConstructorValidator
    extends Validator<VariableElement> {
        private InjectionPointConstructorValidator(IOCContext context, InjectionPointValidator validator) {
            super(context);
            validator.checks.forEach(check -> this.addCheck(check));
        }
    }

    private static class InjectionPointFieldValidator
    extends Validator<VariableElement> {
        private InjectionPointFieldValidator(IOCContext context, InjectionPointValidator validator) {
            super(context);
            validator.checks.forEach(check -> this.addCheck(check));
            this.addCheck(new Check<VariableElement>(){

                @Override
                public void check(VariableElement variableElement) throws UnableToCompleteException {
                    if (variableElement.getModifiers().contains((Object)Modifier.FINAL)) {
                        this.log(variableElement, "Field injection point must not be final", new String[0]);
                    }
                }
            });
            this.addCheck(new Check<VariableElement>(){

                @Override
                public void check(VariableElement variableElement) throws UnableToCompleteException {
                    if (variableElement.getModifiers().contains((Object)Modifier.FINAL)) {
                        this.log(variableElement, "Field injection point must not be final", new String[0]);
                    }
                }
            });
        }
    }
}

