/*
 * Decompiled with CFR 0.152.
 */
package io.crysknife.util;

import io.crysknife.com.google.auto.common.MoreElements;
import io.crysknife.com.google.auto.common.MoreTypes;
import io.crysknife.definition.BeanDefinition;
import io.crysknife.exception.GenerationException;
import io.crysknife.generator.context.IOCContext;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsProperty;

public class Utils {
    private Utils() {
    }

    public static String getQualifiedFactoryName(TypeMirror bean) {
        return Utils.getQualifiedFactoryName(MoreTypes.asTypeElement(bean));
    }

    public static String getQualifiedFactoryName(TypeElement bean) {
        return Utils.getPackageName(bean) + "." + Utils.getFactoryClassName(bean);
    }

    public static String getPackageName(TypeElement singleton) {
        return MoreElements.getPackage(singleton).getQualifiedName().toString();
    }

    public static String getPackageName(TypeMirror type) {
        return Utils.getPackageName(MoreTypes.asTypeElement(type));
    }

    public static String getFactoryClassName(TypeElement bean) {
        return (bean.getEnclosingElement().getKind().equals((Object)ElementKind.PACKAGE) ? "" : bean.getEnclosingElement().getSimpleName() + "_") + bean.getSimpleName().toString() + "_Factory";
    }

    public static String getSimpleClassName(TypeMirror bean) {
        return Utils.getSimpleClassName(MoreTypes.asTypeElement(bean));
    }

    public static String getSimpleClassName(TypeElement bean) {
        return (bean.getEnclosingElement().getKind().equals((Object)ElementKind.PACKAGE) ? "" : bean.getEnclosingElement().getSimpleName() + ".") + bean.getSimpleName().toString();
    }

    public static String getJsFieldName(VariableElement field) {
        if (field.getAnnotation(JsProperty.class) != null) {
            return field.getSimpleName().toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("f_");
        sb.append(field.getSimpleName().toString());
        sb.append("__");
        sb.append(((TypeElement)field.getEnclosingElement()).getQualifiedName().toString().replaceAll("\\.", "_"));
        if (field.getModifiers().contains((Object)Modifier.PRIVATE)) {
            sb.append("_");
        }
        return sb.toString();
    }

    public static String getJsMethodName(ExecutableElement method) {
        String className;
        if (method.getAnnotation(JsMethod.class) != null) {
            return method.getSimpleName().toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("m_");
        sb.append(method.getSimpleName().toString());
        sb.append("__");
        String types = method.getParameters().stream().map(elm -> elm.asType().toString()).map(type -> Utils.maybeErase(type)).map(type -> type.replaceAll("\\.", "_")).collect(Collectors.joining("__"));
        sb.append(types);
        if (method.getModifiers().contains((Object)Modifier.PUBLIC) || method.getModifiers().contains((Object)Modifier.PROTECTED)) {
            return sb.toString();
        }
        if (method.getModifiers().contains((Object)Modifier.PRIVATE)) {
            sb.append("_$p_");
            className = ((TypeElement)method.getEnclosingElement()).getQualifiedName().toString();
        } else {
            sb.append("_$pp_");
            className = method.getEnclosingElement().getEnclosingElement().toString();
        }
        className = Utils.maybeErase(className).replaceAll("\\.", "_");
        sb.append(className);
        return sb.toString();
    }

    private static String maybeErase(String className) {
        if (className.contains("<")) {
            return className.substring(0, className.indexOf("<"));
        }
        return className;
    }

    public static Set<Element> getAnnotatedElements(Elements elements, TypeElement type, Class<? extends Annotation> annotation) {
        HashSet<Element> found = new HashSet<Element>();
        for (Element element : elements.getAllMembers(type)) {
            if (element.getAnnotation(annotation) == null) continue;
            found.add(element);
        }
        return found;
    }

    public static String toVariableName(TypeElement injection) {
        return Utils.toVariableName(Utils.getQualifiedName(injection));
    }

    public static String toVariableName(String name) {
        return name.toLowerCase().replaceAll("\\.", "_");
    }

    public static String getQualifiedName(Element elm) {
        if (elm.getKind().equals((Object)ElementKind.FIELD) || elm.getKind().equals((Object)ElementKind.PARAMETER)) {
            VariableElement variableElement = MoreElements.asVariable(elm);
            DeclaredType declaredType = (DeclaredType)variableElement.asType();
            return declaredType.toString();
        }
        if (elm.getKind().equals((Object)ElementKind.CONSTRUCTOR)) {
            ExecutableElement executableElement = MoreElements.asExecutable(elm);
            return executableElement.getEnclosingElement().toString();
        }
        if (elm.getKind().isClass() || elm.getKind().isInterface()) {
            TypeElement typeElement = MoreElements.asType(elm);
            return typeElement.getQualifiedName().toString();
        }
        throw new GenerationException("Unable to process bean " + elm.toString());
    }

    public static List<AnnotationMirror> getAllElementQualifierAnnotations(IOCContext context, Element element) {
        ArrayList<AnnotationMirror> result = new ArrayList<AnnotationMirror>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (Utils.isAnnotationMirrorOfType(annotationMirror, Named.class.getCanonicalName()) || Utils.isAnnotationMirrorOfType(annotationMirror, Default.class.getCanonicalName())) continue;
            for (AnnotationMirror annotationMirror2 : context.getGenerationContext().getElements().getAllAnnotationMirrors(annotationMirror.getAnnotationType().asElement())) {
                if (!Utils.isAnnotationMirrorOfType(annotationMirror2, Qualifier.class.getCanonicalName())) continue;
                result.add(annotationMirror);
            }
        }
        return result;
    }

    public static boolean isAnnotationMirrorOfType(AnnotationMirror annotationMirror, String fqcn) {
        assert (annotationMirror != null);
        assert (fqcn != null);
        String annotationClassName = annotationMirror.getAnnotationType().toString();
        return annotationClassName.equals(fqcn);
    }

    public static Collection<VariableElement> getAllFieldsIn(Elements elements, TypeElement type) {
        LinkedHashMap fields = new LinkedHashMap();
        ElementFilter.fieldsIn(type.getEnclosedElements()).forEach(field -> fields.put(field.getSimpleName().toString(), field));
        List<TypeElement> alltypes = Utils.getSuperTypes(elements, type);
        for (TypeElement atype : alltypes) {
            ElementFilter.fieldsIn(atype.getEnclosedElements()).stream().filter(field -> !fields.containsKey(field.getSimpleName().toString())).forEach(field -> fields.put(field.getSimpleName().toString(), field));
        }
        return fields.values();
    }

    public static List<TypeElement> getSuperTypes(Elements elements, TypeElement type) {
        ArrayList<TypeElement> superelems = new ArrayList<TypeElement>();
        if (type == null) {
            return superelems;
        }
        ArrayDeque<TypeElement> stack = new ArrayDeque<TypeElement>();
        stack.push(type);
        while (!stack.isEmpty()) {
            TypeElement supercls;
            TypeElement current = (TypeElement)stack.pop();
            TypeMirror supertypecls = current.getSuperclass();
            if (supertypecls.getKind() != TypeKind.NONE && !superelems.contains(supercls = (TypeElement)((DeclaredType)supertypecls).asElement())) {
                stack.push(supercls);
                superelems.add(supercls);
            }
            for (TypeMirror typeMirror : current.getInterfaces()) {
                TypeElement superitf = (TypeElement)((DeclaredType)typeMirror).asElement();
                if (superelems.contains(superitf)) continue;
                stack.push(superitf);
                superelems.add(superitf);
            }
        }
        TypeElement jlobject = elements.getTypeElement(Object.class.getCanonicalName());
        if (!superelems.contains(jlobject)) {
            superelems.add(jlobject);
        }
        return Collections.unmodifiableList(superelems);
    }

    public static Collection<ExecutableType> getAllTypedMethodsIn(Elements elements, Types types, TypeMirror type) {
        return Utils.getAllMethodsIn(elements, MoreTypes.asTypeElement(type)).stream().map(e -> types.asMemberOf(MoreTypes.asDeclared(type), (Element)e)).map(e -> (ExecutableType)e).collect(Collectors.toSet());
    }

    public static Collection<ExecutableElement> getAllMethodsIn(Elements elements, TypeElement type) {
        LinkedHashSet<ExecutableElement> methods = new LinkedHashSet<ExecutableElement>();
        ElementFilter.methodsIn(type.getEnclosedElements()).forEach(method -> methods.add((ExecutableElement)method));
        List<TypeElement> alltypes = Utils.getSuperTypes(elements, type);
        for (TypeElement atype : alltypes) {
            ElementFilter.methodsIn(atype.getEnclosedElements()).stream().filter(method -> !methods.contains(method)).forEach(method -> methods.add((ExecutableElement)method));
        }
        return methods;
    }

    public static boolean containsAnnotation(Element element, String ... annotations) {
        assert (element != null);
        assert (annotations != null);
        ArrayList annotationClassNames = new ArrayList();
        Collections.addAll(annotationClassNames, annotations);
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationClassNames.contains(annotationMirror.getAnnotationType().toString())) continue;
            return true;
        }
        return false;
    }

    public static Object getAnnotationValue(AnnotationMirror annotationMirror, String parameterValue) {
        assert (annotationMirror != null);
        assert (parameterValue != null);
        Object returnValue = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!parameterValue.equals(entry.getKey().getSimpleName().toString())) continue;
            returnValue = entry.getValue().getValue();
            break;
        }
        return returnValue;
    }

    public static boolean isDependent(BeanDefinition beanDefinition) {
        String annotation = beanDefinition.getScope().annotationType().getCanonicalName();
        String dependent = Dependent.class.getCanonicalName();
        return annotation.equals(dependent);
    }
}

