/*
 * Decompiled with CFR 0.152.
 */
package io.crysknife.util;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.ThrowStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import io.crysknife.client.Reflect;
import io.crysknife.client.internal.InstanceImpl;
import io.crysknife.com.google.auto.common.MoreElements;
import io.crysknife.com.google.auto.common.MoreTypes;
import io.crysknife.definition.BeanDefinition;
import io.crysknife.definition.InjectableVariableDefinition;
import io.crysknife.generator.api.ClassBuilder;
import io.crysknife.generator.context.ExecutionEnv;
import io.crysknife.generator.context.IOCContext;
import io.crysknife.util.Utils;
import java.lang.reflect.Method;
import java.util.List;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import jsinterop.base.Js;
import org.apache.commons.lang3.reflect.MethodUtils;

public class GenerationUtils {
    private final IOCContext context;
    private final TypeMirror qualifier;

    public GenerationUtils(IOCContext context) {
        this.context = context;
        this.qualifier = context.getGenerationContext().getElements().getTypeElement(Qualifier.class.getCanonicalName()).asType();
    }

    public boolean isAccessible(TypeMirror caller, ExecutableElement method) {
        TypeMirror methodEnclosingElement = method.getEnclosingElement().asType();
        if (!this.context.getGenerationContext().getTypes().isAssignable(this.erase(caller), this.erase(methodEnclosingElement))) {
            return false;
        }
        if (method.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return true;
        }
        if (method.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return false;
        }
        PackageElement methodPackageElement = MoreElements.getPackage(method);
        PackageElement callerElement = MoreElements.getPackage(MoreTypes.asTypeElement(caller));
        return callerElement.equals(methodPackageElement);
    }

    private TypeMirror erase(TypeMirror mirror) {
        return this.context.getGenerationContext().getTypes().erasure(mirror);
    }

    public String getActualQualifiedBeanName(InjectableVariableDefinition fieldPoint) {
        String typeQualifiedName;
        if (!MoreTypes.asTypeElement(fieldPoint.getVariableElement().asType()).getTypeParameters().isEmpty()) {
            List<? extends TypeParameterElement> params = MoreTypes.asTypeElement(fieldPoint.getVariableElement().asType()).getTypeParameters();
            typeQualifiedName = this.context.getGenerationContext().getTypes().erasure(fieldPoint.getVariableElement().asType()).toString();
            if (fieldPoint.getImplementation().isPresent() && params.get(0).getKind().equals((Object)ElementKind.TYPE_PARAMETER)) {
                typeQualifiedName = fieldPoint.getImplementation().get().getQualifiedName();
            }
        } else {
            typeQualifiedName = this.context.getGenerationContext().getTypes().isSameType(fieldPoint.getVariableElement().asType(), fieldPoint.getImplementation().orElse(fieldPoint.getBeanDefinition()).getType()) ? fieldPoint.getVariableElement().asType().toString() : (fieldPoint.getImplementation().isPresent() ? fieldPoint.getImplementation().get().getQualifiedName() : fieldPoint.getVariableElement().asType().toString());
        }
        return typeQualifiedName;
    }

    public Expression getFieldAccessCallExpr(BeanDefinition beanDefinition, VariableElement field) {
        if (!field.getModifiers().contains((Object)Modifier.PRIVATE) && this.isTheSame(beanDefinition.getType(), field.getEnclosingElement().asType())) {
            return new FieldAccessExpr(new NameExpr("instance"), field.getSimpleName().toString());
        }
        return (Expression)new MethodCallExpr((Expression)new MethodCallExpr((Expression)new NameExpr(Js.class.getSimpleName()), "asPropertyMap").addArgument("instance"), "get").addArgument((Expression)((MethodCallExpr)new MethodCallExpr((Expression)new NameExpr(Reflect.class.getSimpleName()), "objectProperty").addArgument(new StringLiteralExpr(Utils.getJsFieldName(field)))).addArgument("instance"));
    }

    private boolean isTheSame(TypeMirror parent, TypeMirror child) {
        parent = this.context.getGenerationContext().getTypes().erasure(parent);
        child = this.context.getGenerationContext().getTypes().erasure(child);
        return this.context.getGenerationContext().getTypes().isSameType(parent, child);
    }

    public Expression beanManagerLookupBeanCall(InjectableVariableDefinition fieldPoint) {
        MethodCallExpr callForProducer = (MethodCallExpr)new MethodCallExpr((Expression)new NameExpr("beanManager"), "lookupBean").addArgument(new FieldAccessExpr(new NameExpr(MoreTypes.asTypeElement(fieldPoint.getVariableElement().asType()).getQualifiedName().toString()), "class"));
        this.maybeAddQualifiers(this.context, callForProducer, fieldPoint);
        return callForProducer;
    }

    public void maybeAddQualifiers(IOCContext context, MethodCallExpr call, InjectableVariableDefinition field) {
        String annotationName = null;
        if (field.getVariableElement().getAnnotation(Named.class) != null) {
            annotationName = Named.class.getCanonicalName();
        } else if (this.isQualifier(field) != null) {
            annotationName = this.isQualifier(field);
        }
        if (annotationName != null) {
            ObjectCreationExpr annotation = new ObjectCreationExpr();
            annotation.setType((ClassOrInterfaceType)new ClassOrInterfaceType().setName(annotationName));
            NodeList anonymousClassBody = new NodeList();
            MethodDeclaration annotationType = new MethodDeclaration();
            annotationType.setModifiers(Modifier.Keyword.PUBLIC);
            annotationType.setName("annotationType");
            annotationType.setType((Type)new ClassOrInterfaceType().setName("Class<? extends java.lang.annotation.Annotation>"));
            annotationType.getBody().get().addAndGetStatement(new ReturnStmt(new NameExpr(annotationName + ".class")));
            anonymousClassBody.add(annotationType);
            if (field.getVariableElement().getAnnotation(Named.class) != null) {
                MethodDeclaration value = new MethodDeclaration();
                value.setModifiers(Modifier.Keyword.PUBLIC);
                value.setName("value");
                value.setType((Type)new ClassOrInterfaceType().setName("String"));
                value.getBody().get().addAndGetStatement(new ReturnStmt(new StringLiteralExpr(field.getVariableElement().getAnnotation(Named.class).value())));
                anonymousClassBody.add(value);
            }
            annotation.setAnonymousClassBody(anonymousClassBody);
            call.addArgument(annotation);
        }
    }

    public boolean isAssignableFrom(TypeMirror typeMirror, Class<?> targetClass) {
        return this.isAssignableFrom(typeMirror, this.context.getGenerationContext().getElements().getTypeElement(targetClass.getCanonicalName()));
    }

    public boolean isAssignableFrom(TypeMirror typeMirror, TypeElement targetClass) {
        return this.context.getGenerationContext().getTypes().isAssignable(typeMirror, this.context.getGenerationContext().getTypes().getDeclaredType(targetClass, new TypeMirror[0]));
    }

    public Expression createQualifierExpression(AnnotationMirror qualifier) {
        ObjectCreationExpr annotation = new ObjectCreationExpr();
        annotation.setType((ClassOrInterfaceType)new ClassOrInterfaceType().setName(qualifier.getAnnotationType().toString()));
        NodeList anonymousClassBody = new NodeList();
        MethodDeclaration annotationType = new MethodDeclaration();
        annotationType.setModifiers(Modifier.Keyword.PUBLIC);
        annotationType.setName("annotationType");
        annotationType.setType((Type)new ClassOrInterfaceType().setName("Class<? extends java.lang.annotation.Annotation>"));
        annotationType.getBody().get().addAndGetStatement(new ReturnStmt(new NameExpr(qualifier.getAnnotationType().toString() + ".class")));
        anonymousClassBody.add(annotationType);
        qualifier.getElementValues().forEach((name, type) -> {
            MethodDeclaration annotationTypeDeclaration = new MethodDeclaration();
            annotationTypeDeclaration.setModifiers(Modifier.Keyword.PUBLIC);
            annotationTypeDeclaration.setName(name.getSimpleName().toString());
            annotationTypeDeclaration.setType((Type)new ClassOrInterfaceType().setName(type.getValue().getClass().getCanonicalName()));
            annotationTypeDeclaration.getBody().get().addAndGetStatement(new ReturnStmt(new NameExpr(type.toString())));
            anonymousClassBody.add(annotationTypeDeclaration);
        });
        annotation.setAnonymousClassBody(anonymousClassBody);
        return annotation;
    }

    public String isQualifier(InjectableVariableDefinition field) {
        for (AnnotationMirror annotationMirror : field.getVariableElement().getAnnotationMirrors()) {
            for (AnnotationMirror annotationMirror2 : this.context.getGenerationContext().getProcessingEnvironment().getElementUtils().getAllAnnotationMirrors(MoreTypes.asElement(annotationMirror.getAnnotationType()))) {
                boolean same = this.context.getGenerationContext().getTypes().isSameType(annotationMirror2.getAnnotationType(), this.qualifier);
                if (!same) continue;
                return annotationMirror.getAnnotationType().toString();
            }
        }
        return null;
    }

    public Expression wrapCallInstanceImpl(ClassBuilder classBuilder, Expression call) {
        classBuilder.getClassCompilationUnit().addImport(InstanceImpl.class);
        LambdaExpr lambda = new LambdaExpr();
        lambda.setEnclosingParameters(true);
        lambda.setBody(new ExpressionStmt(call));
        return (Expression)((ObjectCreationExpr)new ObjectCreationExpr().setType(InstanceImpl.class)).addArgument(call);
    }

    public Statement generateMethodCall(TypeMirror parent, ExecutableElement method, Expression ... args) {
        if (method.getModifiers().contains((Object)Modifier.PRIVATE)) {
            if (this.context.getGenerationContext().getExecutionEnv().equals((Object)ExecutionEnv.JRE)) {
                return this.generatePrivateJREMethodCall(method, args);
            }
            if (this.context.getGenerationContext().getExecutionEnv().equals((Object)ExecutionEnv.J2CL)) {
                return this.generatePrivateJ2CLMethodCall(method, args);
            }
            throw new Error("Private method calls aren't supported for GWT2");
        }
        if (this.isTheSame(parent, method.getEnclosingElement().asType()) || this.context.getGenerationContext().getExecutionEnv().equals((Object)ExecutionEnv.JRE)) {
            MethodCallExpr result = new MethodCallExpr((Expression)new NameExpr("instance"), method.getSimpleName().toString());
            for (Expression arg : args) {
                result.addArgument((Expression)new MethodCallExpr((Expression)new NameExpr(Js.class.getCanonicalName()), "uncheckedCast").addArgument(arg));
            }
            return new ExpressionStmt(result);
        }
        if (this.isAccessible(parent, method)) {
            MethodCallExpr call = new MethodCallExpr((Expression)new NameExpr("instance"), method.getSimpleName().toString());
            for (Expression arg : args) {
                call.addArgument(arg);
            }
            return new ExpressionStmt(call);
        }
        MethodCallExpr call = (MethodCallExpr)new MethodCallExpr((Expression)new MethodCallExpr((Expression)new NameExpr(Js.class.getCanonicalName()), "<elemental2.core.Function>uncheckedCast").addArgument((Expression)((MethodCallExpr)new MethodCallExpr((Expression)new NameExpr("elemental2.core.Reflect"), "get").addArgument("instance")).addArgument((Expression)((MethodCallExpr)new MethodCallExpr((Expression)new NameExpr(Reflect.class.getCanonicalName()), "objectProperty").addArgument(new StringLiteralExpr(Utils.getJsMethodName(method)))).addArgument("instance"))), "bind").addArgument("instance");
        for (Expression arg : args) {
            call.addArgument(arg);
        }
        return new ExpressionStmt(new MethodCallExpr((Expression)call, "call"));
    }

    private Statement generatePrivateJ2CLMethodCall(ExecutableElement method, Expression[] args) {
        String valueName = Utils.getJsMethodName(method);
        MethodCallExpr bind = (MethodCallExpr)new MethodCallExpr((Expression)new EnclosedExpr(new CastExpr((Type)new ClassOrInterfaceType().setName("elemental2.core.Function"), (Expression)((MethodCallExpr)new MethodCallExpr((Expression)new NameExpr("elemental2.core.Reflect"), "get").addArgument("instance")).addArgument((Expression)((MethodCallExpr)new MethodCallExpr((Expression)new NameExpr("io.crysknife.client.Reflect"), "objectProperty").addArgument(new StringLiteralExpr(valueName))).addArgument("instance")))), "bind").addArgument("instance");
        for (Expression arg : args) {
            bind.addArgument(arg);
        }
        return new ExpressionStmt(new MethodCallExpr((Expression)bind, "call"));
    }

    private TryStmt generatePrivateJREMethodCall(ExecutableElement method, Expression[] args) {
        ThrowStmt throwStmt = new ThrowStmt((Expression)new ObjectCreationExpr().setType((ClassOrInterfaceType)new ClassOrInterfaceType().setName("Error")).addArgument("e"));
        TryStmt ts = new TryStmt();
        BlockStmt blockStmt = new BlockStmt();
        MethodCallExpr getDeclaredMethod = new MethodCallExpr((Expression)new NameExpr(MethodUtils.class.getCanonicalName()), "getMatchingMethod");
        getDeclaredMethod.addArgument(method.getEnclosingElement().toString() + ".class");
        getDeclaredMethod.addArgument(new StringLiteralExpr(method.getSimpleName().toString()));
        method.getParameters().forEach(param -> getDeclaredMethod.addArgument(param.asType().toString() + ".class"));
        blockStmt.addAndGetStatement(new AssignExpr().setTarget(new VariableDeclarationExpr((Type)new ClassOrInterfaceType().setName(Method.class.getCanonicalName()), "method")).setValue(getDeclaredMethod));
        blockStmt.addAndGetStatement((Expression)new MethodCallExpr((Expression)new NameExpr("method"), "setAccessible").addArgument("true"));
        MethodCallExpr invoke = (MethodCallExpr)new MethodCallExpr((Expression)new NameExpr("method"), "invoke").addArgument("instance");
        for (Expression arg : args) {
            invoke.addArgument(arg);
        }
        blockStmt.addAndGetStatement(invoke);
        CatchClause catchClause1 = new CatchClause().setParameter((Parameter)new Parameter().setType((Type)new ClassOrInterfaceType().setName("Exception")).setName("e"));
        catchClause1.getBody().addAndGetStatement(throwStmt);
        ts.getCatchClauses().add(catchClause1);
        ts.setTryBlock(blockStmt);
        return ts;
    }
}

