/*
 * Decompiled with CFR 0.152.
 */
package io.crysknife.processor;

import io.crysknife.definition.BeanDefinition;
import io.crysknife.exception.UnableToCompleteException;
import io.crysknife.generator.context.IOCContext;
import io.crysknife.logger.TreeLogger;
import io.crysknife.validation.InjectionPointValidator;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.VariableElement;

public abstract class InjectionPointProcessor {
    protected final IOCContext context;
    protected final TreeLogger logger;

    public InjectionPointProcessor(IOCContext context, TreeLogger logger) {
        this.context = context;
        this.logger = logger;
    }

    public abstract void process(BeanDefinition var1) throws UnableToCompleteException;

    protected void process(BeanDefinition bean, Set<VariableElement> points) throws UnableToCompleteException {
        HashSet<UnableToCompleteException> errors = new HashSet<UnableToCompleteException>();
        for (VariableElement field : points) {
            try {
                new InjectionPointValidator(this.context, field.getEnclosingElement()).validate(field);
                this.process(bean, field);
            }
            catch (UnableToCompleteException e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            TreeLogger logger = this.logger.branch(TreeLogger.ERROR, "Unable to process bean: " + bean.getType());
            for (UnableToCompleteException error : errors) {
                logger.log(TreeLogger.ERROR, error.getMessage());
            }
            throw new UnableToCompleteException();
        }
    }

    protected abstract void process(BeanDefinition var1, VariableElement var2) throws UnableToCompleteException;
}

