/*
 * Decompiled with CFR 0.152.
 */
package io.crysknife.processor;

import io.crysknife.com.google.auto.common.MoreElements;
import io.crysknife.com.google.auto.common.MoreTypes;
import io.crysknife.definition.BeanDefinition;
import io.crysknife.definition.InjectionParameterDefinition;
import io.crysknife.exception.GenerationException;
import io.crysknife.exception.UnableToCompleteException;
import io.crysknife.generator.context.IOCContext;
import io.crysknife.logger.TreeLogger;
import io.crysknife.processor.InjectionPointProcessor;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public class ConstructorInjectionPointProcessor
extends InjectionPointProcessor {
    public ConstructorInjectionPointProcessor(IOCContext context, TreeLogger logger) {
        super(context, logger);
    }

    @Override
    public void process(BeanDefinition bean) throws UnableToCompleteException {
        List constructors = this.context.getGenerationContext().getElements().getAllMembers(MoreTypes.asTypeElement(bean.getType())).stream().filter(field -> field.getKind().equals((Object)ElementKind.CONSTRUCTOR)).filter(elm -> elm.getAnnotation(Inject.class) != null).map(elm -> MoreElements.asExecutable(elm)).collect(Collectors.toList());
        if (constructors.isEmpty()) {
            return;
        }
        if (constructors.size() > 1) {
            throw new GenerationException(bean.getType() + "must contain only one constructor annotated with @Inject");
        }
        ExecutableElement constructor = (ExecutableElement)constructors.iterator().next();
        for (int i = 0; i < constructor.getParameters().size(); ++i) {
            this.process(bean, constructor.getParameters().get(i));
        }
    }

    @Override
    protected void process(BeanDefinition bean, VariableElement field) throws UnableToCompleteException {
        bean.getConstructorParams().add(new InjectionParameterDefinition(bean, field));
    }
}

