/*
 * Decompiled with CFR 0.152.
 */
package io.crysknife.logger;

import java.net.URL;

public abstract class TreeLogger {
    public static final Type ERROR = Type.ERROR;
    public static final Type WARN = Type.WARN;
    public static final Type INFO = Type.INFO;
    public static final Type TRACE = Type.TRACE;
    public static final Type DEBUG = Type.DEBUG;
    public static final Type SPAM = Type.SPAM;
    public static final Type ALL = Type.ALL;
    public static final TreeLogger NULL = new TreeLogger(){

        @Override
        public TreeLogger branch(Type type, String msg, Throwable caught, HelpInfo helpInfo) {
            return this;
        }

        @Override
        public boolean isLoggable(Type type) {
            return false;
        }

        @Override
        public void log(Type type, String msg, Throwable caught, HelpInfo helpInfo) {
        }
    };

    public final TreeLogger branch(Type type, String msg) {
        return this.branch(type, msg, null, null);
    }

    public final TreeLogger branch(Type type, String msg, Throwable caught) {
        return this.branch(type, msg, caught, null);
    }

    public abstract TreeLogger branch(Type var1, String var2, Throwable var3, HelpInfo var4);

    public abstract boolean isLoggable(Type var1);

    public final void log(Type type, String msg) {
        this.log(type, msg, null, null);
    }

    public final void log(Type type, String msg, Throwable caught) {
        this.log(type, msg, caught, null);
    }

    public abstract void log(Type var1, String var2, Throwable var3, HelpInfo var4);

    public static enum Type {
        ERROR(true),
        WARN(true),
        INFO(false),
        TRACE(false),
        DEBUG(false),
        SPAM(false),
        ALL(false);

        private final boolean needsAttention;

        public static Type[] instances() {
            return Type.values();
        }

        private Type(boolean needsAttention) {
            this.needsAttention = needsAttention;
        }

        public String getLabel() {
            return this.toString();
        }

        public boolean isLowerPriorityThan(Type other) {
            return this.ordinal() > other.ordinal();
        }

        public boolean needsAttention() {
            return this.needsAttention;
        }
    }

    public static abstract class HelpInfo {
        public String getAnchorText() {
            return null;
        }

        public String getPrefix() {
            return "More info: ";
        }

        public URL getURL() {
            return null;
        }
    }
}

