/*
 * Decompiled with CFR 0.152.
 */
package io.crysknife.generator.context.oracle;

import io.crysknife.com.google.auto.common.MoreElements;
import io.crysknife.exception.UnableToCompleteException;
import io.crysknife.generator.context.GenerationContext;
import io.crysknife.generator.context.oracle.ResourceOracle;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.ExecutableElement;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

public class ResourceOracleImpl
implements ResourceOracle {
    private final GenerationContext aptContext;

    public ResourceOracleImpl(GenerationContext context) {
        this.aptContext = context;
    }

    private URL[] getResourcesByExtensions(ExecutableElement method, String[] extensions) throws UnableToCompleteException {
        String[] paths = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            StringBuffer sb = new StringBuffer();
            sb.append(method.getSimpleName().toString()).append(extensions[i]);
            paths[i] = sb.toString();
        }
        return this.findResources(MoreElements.getPackage(method).getQualifiedName().toString(), paths);
    }

    @Override
    public URL[] findResources(String packageName, String[] pathName) {
        ArrayList<URL> result = new ArrayList<URL>();
        for (int i = 0; i < pathName.length; ++i) {
            URL resource = this.findResource(packageName, pathName[i]);
            if (resource != null) {
                result.add(resource);
                continue;
            }
            resource = this.findResource(pathName[i]);
            if (resource == null) continue;
            result.add(resource);
        }
        if (result.size() > 0) {
            return result.toArray(new URL[result.size()]);
        }
        return null;
    }

    @Override
    public URL findResource(String path) {
        URL resource = this.getUrlClassLoader(path);
        if (resource != null) {
            return resource;
        }
        String packageName = "";
        String relativeName = path;
        int index = relativeName.lastIndexOf(47);
        if (index >= 0) {
            packageName = relativeName.substring(0, index).replace('/', '.');
            relativeName = relativeName.substring(index + 1);
        }
        return this.findResource(packageName, relativeName);
    }

    @Override
    public URL findResource(String pkg, String relativeName) {
        URL resource = this.getUrlClassLoader(pkg.replaceAll("\\.", "/") + relativeName);
        if (resource != null) {
            return resource;
        }
        return this.findResource(Arrays.asList(StandardLocation.SOURCE_PATH, StandardLocation.SOURCE_OUTPUT, StandardLocation.CLASS_PATH, StandardLocation.CLASS_OUTPUT, StandardLocation.ANNOTATION_PROCESSOR_PATH), pkg, relativeName);
    }

    private URL findResource(List<JavaFileManager.Location> searchLocations, CharSequence pkg, CharSequence relativeName) {
        if (searchLocations == null || searchLocations.isEmpty()) {
            return null;
        }
        for (JavaFileManager.Location location : searchLocations) {
            String path = "";
            if (pkg.length() > 0) {
                path = String.valueOf(pkg).replace('.', File.separatorChar) + '/';
            }
            try {
                FileObject fileObject = this.aptContext.getProcessingEnvironment().getFiler().getResource(location, "", path + relativeName);
                if (!new File(fileObject.getName()).exists()) continue;
                return fileObject.toUri().toURL();
            }
            catch (FilerException ignored) {
                File openedfile = new File(ignored.getMessage().replace("Attempt to reopen a file for path ", ""));
                if (!openedfile.exists()) continue;
                try {
                    return openedfile.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                }
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private URL getUrlClassLoader(String path) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL resource = classLoader.getResource(path);
        if (resource != null) {
            return resource;
        }
        return null;
    }
}

