/*
 * Decompiled with CFR 0.152.
 */
package io.crysknife.generator.context;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import io.crysknife.definition.BeanDefinition;
import io.crysknife.definition.BeanDefinitionFactory;
import io.crysknife.exception.GenerationException;
import io.crysknife.exception.UnableToCompleteException;
import io.crysknife.generator.IOCGenerator;
import io.crysknife.generator.WiringElementType;
import io.crysknife.generator.context.GenerationContext;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public class IOCContext {
    private final SetMultimap<IOCGeneratorMeta, IOCGenerator> generators = HashMultimap.create();
    private final Map<TypeMirror, BeanDefinition> beans = new HashMap<TypeMirror, BeanDefinition>();
    private final GenerationContext generationContext;
    private final List<TypeMirror> orderedBeans = new LinkedList<TypeMirror>();
    private final List<String> buildIn = new ArrayList<String>();
    private final Map<String, Set<TypeElement>> classesByAnnotation = new HashMap<String, Set<TypeElement>>();
    private final Map<String, Set<ExecutableElement>> methodsByAnnotation = new HashMap<String, Set<ExecutableElement>>();
    private final Map<String, Set<VariableElement>> fieldsByAnnotation = new HashMap<String, Set<VariableElement>>();
    private final Map<String, Set<VariableElement>> parametersByAnnotation = new HashMap<String, Set<VariableElement>>();
    private final BeanDefinitionFactory beanDefinitionFactory;

    public IOCContext(GenerationContext generationContext) {
        this.generationContext = generationContext;
        this.beanDefinitionFactory = new BeanDefinitionFactory(this, null);
    }

    public void register(Class annotation, WiringElementType wiringElementType, IOCGenerator generator) {
        this.register(annotation, Object.class, wiringElementType, generator);
    }

    public void register(Class annotation, Class exactType, WiringElementType wiringElementType, IOCGenerator generator) {
        TypeElement type = this.getGenerationContext().getElements().getTypeElement(exactType.getCanonicalName());
        this.generators.put(new IOCGeneratorMeta(annotation.getCanonicalName(), type, wiringElementType), generator);
        if (!exactType.equals(Object.class)) {
            BeanDefinition beanDefinition = null;
            try {
                beanDefinition = this.getBeanDefinitionOrCreateAndReturn(type.asType());
            }
            catch (UnableToCompleteException e) {
                e.printStackTrace();
            }
            beanDefinition.setIocGenerator(generator);
            this.getBeans().put(type.asType(), beanDefinition);
            this.buildIn.add(exactType.getCanonicalName());
        }
    }

    public GenerationContext getGenerationContext() {
        return this.generationContext;
    }

    public BeanDefinition getBeanDefinitionOrCreateAndReturn(TypeMirror typeElement) throws UnableToCompleteException {
        TypeMirror candidate = this.generationContext.getTypes().erasure(typeElement);
        if (this.beans.containsKey(candidate)) {
            return this.beans.get(candidate);
        }
        BeanDefinition beanDefinition = this.beanDefinitionFactory.of(candidate);
        this.beans.put(candidate, beanDefinition);
        return beanDefinition;
    }

    public Map<TypeMirror, BeanDefinition> getBeans() {
        return this.beans;
    }

    public BeanDefinition getBean(TypeMirror type) {
        TypeMirror erased = this.generationContext.getTypes().erasure(type);
        if (!this.beans.containsKey(erased)) {
            throw new GenerationException("Unable to find Bean [" + erased + "], check scopes");
        }
        return this.beans.get(erased);
    }

    public SetMultimap<IOCGeneratorMeta, IOCGenerator> getGenerators() {
        return this.generators;
    }

    public List<TypeMirror> getOrderedBeans() {
        return this.orderedBeans;
    }

    public List<String> getBuildIn() {
        return this.buildIn;
    }

    public Set<TypeElement> getTypeElementsByAnnotation(String annotation) {
        if (this.classesByAnnotation.containsKey(annotation)) {
            return this.classesByAnnotation.get(annotation);
        }
        Elements elements = this.getGenerationContext().getElements();
        Set<TypeElement> results = this.getElementsByAnnotation(annotation).stream().filter(elm -> elm instanceof TypeElement).map(element -> (TypeElement)element).collect(Collectors.toSet());
        ClassInfoList routeClassInfoList = this.generationContext.getScanResult().getClassesWithAnnotation(annotation);
        for (ClassInfo routeClassInfo : routeClassInfoList) {
            TypeElement type = elements.getTypeElement(routeClassInfo.getName());
            if (type == null) continue;
            results.add(type);
        }
        this.classesByAnnotation.put(annotation, results);
        return results;
    }

    private Set<Element> getElementsByAnnotation(String annotation) {
        Elements elements = this.getGenerationContext().getElements();
        return this.getGenerationContext().getRoundEnvironment().getElementsAnnotatedWith(elements.getTypeElement(annotation));
    }

    public Set<ExecutableElement> getMethodsByAnnotation(String annotation) {
        if (this.methodsByAnnotation.containsKey(annotation)) {
            return this.methodsByAnnotation.get(annotation);
        }
        Elements elements = this.getGenerationContext().getElements();
        Set<ExecutableElement> results = this.getGenerationContext().getRoundEnvironment().getElementsAnnotatedWith(elements.getTypeElement(annotation)).stream().filter(elm -> elm instanceof ExecutableElement).map(element -> (ExecutableElement)element).collect(Collectors.toSet());
        ClassInfoList routeClassInfoList = this.generationContext.getScanResult().getClassesWithMethodAnnotation(annotation);
        for (ClassInfo routeClassInfo : routeClassInfoList) {
            if (routeClassInfo.getDeclaredMethodInfo().asMap().isEmpty()) continue;
            TypeElement type = elements.getTypeElement(routeClassInfo.getName());
            type.getEnclosedElements().stream().filter(elm -> elm.getAnnotationMirrors().stream().map(a -> a.getAnnotationType().toString()).filter(a -> a.equals(annotation)).count() > 0L).map(method -> (ExecutableElement)method).forEach(results::add);
        }
        this.methodsByAnnotation.put(annotation, results);
        return results;
    }

    public Set<VariableElement> getParametersByAnnotation(String annotation) {
        if (this.parametersByAnnotation.containsKey(annotation)) {
            return this.parametersByAnnotation.get(annotation);
        }
        Elements elements = this.getGenerationContext().getElements();
        Set<VariableElement> results = this.getGenerationContext().getRoundEnvironment().getElementsAnnotatedWith(elements.getTypeElement(annotation)).stream().filter(elm -> elm.getKind().equals((Object)ElementKind.PARAMETER)).map(element -> (VariableElement)element).collect(Collectors.toSet());
        ClassInfoList routeClassInfoList = this.generationContext.getScanResult().getClassesWithMethodParameterAnnotation(annotation);
        for (ClassInfo routeClassInfo : routeClassInfoList) {
            if (routeClassInfo.getDeclaredMethodInfo().asMap().isEmpty()) continue;
            TypeElement type = elements.getTypeElement(routeClassInfo.getName());
            for (Element element2 : type.getEnclosedElements()) {
                if (!(element2 instanceof ExecutableElement)) continue;
                ExecutableElement method = (ExecutableElement)element2;
                method.getParameters().forEach(param -> param.getAnnotationMirrors().forEach(ano -> {
                    if (ano.getAnnotationType().toString().equals(annotation)) {
                        results.add((VariableElement)param);
                    }
                }));
            }
        }
        this.parametersByAnnotation.put(annotation, results);
        return results;
    }

    public TypeMirror getTypeMirror(Class clazz) {
        return this.getTypeMirror(clazz.getCanonicalName());
    }

    public TypeMirror getTypeMirror(String clazz) {
        return this.generationContext.getElements().getTypeElement(clazz).asType();
    }

    public Set<VariableElement> getFieldsByAnnotation(String annotation) {
        if (this.fieldsByAnnotation.containsKey(annotation)) {
            return this.fieldsByAnnotation.get(annotation);
        }
        Elements elements = this.getGenerationContext().getElements();
        Set<VariableElement> results = this.getGenerationContext().getRoundEnvironment().getElementsAnnotatedWith(elements.getTypeElement(annotation)).stream().filter(elm -> elm instanceof VariableElement).map(element -> (VariableElement)element).collect(Collectors.toSet());
        ClassInfoList routeClassInfoList = this.generationContext.getScanResult().getClassesWithFieldAnnotation(annotation);
        for (ClassInfo routeClassInfo : routeClassInfoList) {
            TypeElement type;
            if (routeClassInfo.getDeclaredFieldInfo().asMap().isEmpty() || (type = elements.getTypeElement(routeClassInfo.getName())) == null) continue;
            type.getEnclosedElements().stream().filter(elm -> elm instanceof VariableElement).filter(elm -> elm.getAnnotationMirrors().stream().map(a -> a.getAnnotationType().toString()).filter(a -> a.equals(annotation)).count() > 0L).map(method -> (VariableElement)method).forEach(results::add);
        }
        this.fieldsByAnnotation.put(annotation, results);
        return results;
    }

    public Optional<IOCGenerator> getGenerator(String annotation, TypeElement type, WiringElementType wiringElementType) {
        IOCGeneratorMeta meta = new IOCGeneratorMeta(annotation, type, wiringElementType);
        Collection generators = this.getGenerators().get((Object)meta);
        if (generators.iterator().hasNext()) {
            return Optional.of((IOCGenerator)generators.iterator().next());
        }
        return Optional.empty();
    }

    public static class IOCGeneratorMeta {
        public final String annotation;
        public final TypeElement exactType;
        public final WiringElementType wiringElementType;

        public IOCGeneratorMeta(String annotation, TypeElement exactType, WiringElementType wiringElementType) {
            this.annotation = annotation;
            this.wiringElementType = wiringElementType;
            this.exactType = exactType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.annotation, this.exactType, this.wiringElementType});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IOCGeneratorMeta)) {
                return false;
            }
            IOCGeneratorMeta that = (IOCGeneratorMeta)o;
            return Objects.equals(this.annotation, that.annotation) && Objects.equals(this.exactType, that.exactType) && this.wiringElementType == that.wiringElementType;
        }

        public String toString() {
            return "IOCGeneratorMeta{annotation='" + this.annotation + '\'' + ", exactType=" + this.exactType + ", wiringElementType=" + (Object)((Object)this.wiringElementType) + '}';
        }
    }
}

