/*
 * Decompiled with CFR 0.152.
 */
package io.crysknife.generator.context;

import io.crysknife.generator.context.ExecutionEnv;
import io.crysknife.generator.context.oracle.ResourceOracle;
import io.crysknife.generator.context.oracle.ResourceOracleImpl;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class GenerationContext {
    private final RoundEnvironment roundEnvironment;
    private final ProcessingEnvironment processingEnvironment;
    private final ScanResult scanResult = new ClassGraph().enableAllInfo().scan();
    private final ResourceOracle resourceOracle = new ResourceOracleImpl(this);
    private ExecutionEnv executionEnv = ExecutionEnv.J2CL;

    public GenerationContext(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnvironment) {
        this.roundEnvironment = roundEnvironment;
        this.processingEnvironment = processingEnvironment;
        try {
            Class.forName("org.aspectj.lang.ProceedingJoinPoint");
            this.executionEnv = ExecutionEnv.JRE;
            processingEnvironment.getMessager().printMessage(Diagnostic.Kind.WARNING, "JRE generation mode.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        System.out.println("Current generation mode: " + (Object)((Object)this.executionEnv));
    }

    public ExecutionEnv getExecutionEnv() {
        return this.executionEnv;
    }

    public Elements getElements() {
        return this.processingEnvironment.getElementUtils();
    }

    public Types getTypes() {
        return this.processingEnvironment.getTypeUtils();
    }

    public RoundEnvironment getRoundEnvironment() {
        return this.roundEnvironment;
    }

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnvironment;
    }

    public ResourceOracle getResourceOracle() {
        return this.resourceOracle;
    }

    public ScanResult getScanResult() {
        return this.scanResult;
    }
}

