/*
 * Decompiled with CFR 0.152.
 */
package io.crysknife.generator.api;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import io.crysknife.definition.BeanDefinition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ClassBuilder {
    public final BeanDefinition beanDefinition;
    private Set<Expression> statementToConstructor = new HashSet<Expression>();
    private CompilationUnit clazz = new CompilationUnit();
    private ClassOrInterfaceDeclaration classDeclaration;
    private MethodDeclaration getGetMethodDeclaration;
    private MethodDeclaration initMethodDeclaration;
    private ConstructorDeclaration constructorDeclaration;
    private MethodDeclaration onDestroy;
    private HashMap<String, FieldDeclaration> fields = new HashMap();

    public ClassBuilder(BeanDefinition beanDefinition) {
        this.beanDefinition = beanDefinition;
    }

    public void build() {
        this.beanDefinition.getIocGenerator().ifPresent(iocGenerator -> iocGenerator.generate(this, this.beanDefinition));
    }

    public String toSourceCode() {
        return this.clazz.toString();
    }

    public CompilationUnit getClassCompilationUnit() {
        return this.clazz;
    }

    public void setClassName(String className) {
        this.classDeclaration = this.clazz.addClass(className);
        this.onDestroy = this.classDeclaration.addMethod("onDestroy", Modifier.Keyword.PROTECTED);
    }

    public MethodDeclaration getGetMethodDeclaration() {
        return this.getGetMethodDeclaration;
    }

    public void setGetMethodDeclaration(MethodDeclaration getMethodDeclaration) {
        this.getGetMethodDeclaration = getMethodDeclaration;
    }

    public FieldDeclaration addField(Type type, String name, Modifier.Keyword ... modifiers) {
        if (this.fields.containsKey(name)) {
            return this.fields.get(name);
        }
        FieldDeclaration fieldDeclaration = null;
        if (this.getClassDeclaration() != null) {
            fieldDeclaration = this.classDeclaration.addField(type, name, modifiers);
            this.fields.put(name, fieldDeclaration);
        }
        return fieldDeclaration;
    }

    public ClassOrInterfaceDeclaration getClassDeclaration() {
        return this.classDeclaration;
    }

    public FieldDeclaration addField(String type, String name, Modifier.Keyword ... modifiers) {
        if (this.fields.containsKey(name)) {
            return this.fields.get(name);
        }
        FieldDeclaration fieldDeclaration = this.getClassDeclaration().addField(type, name, modifiers);
        this.fields.put(name, fieldDeclaration);
        return fieldDeclaration;
    }

    public NodeList<ClassOrInterfaceType> getExtendedTypes() {
        return this.getClassDeclaration().getExtendedTypes();
    }

    public ConstructorDeclaration addConstructorDeclaration(Modifier.Keyword ... modifiers) {
        if (this.constructorDeclaration == null) {
            this.constructorDeclaration = this.classDeclaration.addConstructor(modifiers);
        }
        return this.constructorDeclaration;
    }

    public void addParametersToConstructor(Parameter p) {
        this.getConstructorDeclaration().getParameters().add(p);
    }

    private ConstructorDeclaration getConstructorDeclaration() {
        return this.constructorDeclaration;
    }

    public void addStatementToConstructor(Expression expr) {
        if (this.constructorDeclaration == null) {
            this.constructorDeclaration = this.classDeclaration.addConstructor(Modifier.Keyword.PUBLIC);
        }
        if (!this.statementToConstructor.contains(expr)) {
            this.getConstructorDeclaration().getBody().addStatement(expr);
            this.statementToConstructor.add(expr);
        }
    }

    public MethodDeclaration addMethod(String methodName, Modifier.Keyword ... modifiers) {
        return this.getClassDeclaration().addMethod(methodName, modifiers);
    }

    public NodeList<ClassOrInterfaceType> getImplementedTypes() {
        return this.getClassDeclaration().getImplementedTypes();
    }

    public FieldDeclaration addFieldWithInitializer(Type type, String name, Expression initializer, Modifier.Keyword ... modifiers) {
        FieldDeclaration fieldDeclaration = this.getClassDeclaration().addFieldWithInitializer(type, name, initializer, modifiers);
        this.fields.put(name, fieldDeclaration);
        return fieldDeclaration;
    }

    public FieldDeclaration addFieldWithInitializer(String type, String name, Expression initializer, Modifier.Keyword ... modifiers) {
        FieldDeclaration fieldDeclaration = this.getClassDeclaration().addFieldWithInitializer(type, name, initializer, modifiers);
        this.fields.put(name, fieldDeclaration);
        return fieldDeclaration;
    }

    public MethodDeclaration addInitInstanceMethod() {
        this.initMethodDeclaration = this.classDeclaration.addMethod("doInitInstance", Modifier.Keyword.PUBLIC);
        return this.initMethodDeclaration;
    }

    public MethodDeclaration getInitInstanceMethod() {
        return this.initMethodDeclaration;
    }

    public MethodDeclaration getOnDestroyMethod() {
        return this.onDestroy;
    }
}

