/*
 * Decompiled with CFR 0.152.
 */
package io.crysknife.generator;

import io.crysknife.definition.BeanDefinition;
import io.crysknife.exception.GenerationException;
import io.crysknife.generator.IOCGenerator;
import io.crysknife.generator.api.ClassBuilder;
import io.crysknife.generator.context.IOCContext;
import io.crysknife.logger.TreeLogger;
import io.crysknife.util.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

public abstract class BeanIOCGenerator<T extends BeanDefinition>
extends IOCGenerator<T> {
    public BeanIOCGenerator(TreeLogger treeLogger, IOCContext iocContext) {
        super(treeLogger, iocContext);
    }

    public void write(ClassBuilder clazz, T beanDefinition) {
        try {
            String fileName = Utils.getQualifiedFactoryName(((BeanDefinition)beanDefinition).getType());
            String source = clazz.toSourceCode();
            this.build(fileName, source);
        }
        catch (FilerException fileName) {
        }
        catch (IOException e1) {
            throw new GenerationException(e1);
        }
    }

    protected void build(String fileName, String source) throws IOException {
        JavaFileObject builderFile = this.iocContext.getGenerationContext().getProcessingEnvironment().getFiler().createSourceFile(fileName, new Element[0]);
        try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
            out.append(source);
        }
        catch (FilerException e) {
            throw new GenerationException(e);
        }
    }
}

