/*
 * Decompiled with CFR 0.152.
 */
package io.crysknife.definition;

import io.crysknife.annotation.CircularDependency;
import io.crysknife.com.google.auto.common.MoreTypes;
import io.crysknife.definition.Definition;
import io.crysknife.definition.InjectableVariableDefinition;
import io.crysknife.definition.InjectionParameterDefinition;
import io.crysknife.definition.MethodDefinition;
import io.crysknife.generator.IOCGenerator;
import io.crysknife.util.Utils;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeMirror;

public class BeanDefinition
implements Definition {
    private final TypeMirror type;
    private Set<InjectableVariableDefinition> fields = new LinkedHashSet<InjectableVariableDefinition>();
    private Set<InjectionParameterDefinition> constructorParams = new LinkedHashSet<InjectionParameterDefinition>();
    private Set<MethodDefinition> methods = new LinkedHashSet<MethodDefinition>();
    private Set<BeanDefinition> dependencies = new LinkedHashSet<BeanDefinition>();
    private Set<IOCGenerator<BeanDefinition>> decorators = new LinkedHashSet<IOCGenerator<BeanDefinition>>();
    private Optional<IOCGenerator<BeanDefinition>> iocGenerator = Optional.empty();
    private boolean hasFactory = true;
    private Set<BeanDefinition> subclasses = new LinkedHashSet<BeanDefinition>();

    public BeanDefinition(TypeMirror type) {
        this.type = type;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public Set<InjectableVariableDefinition> getFields() {
        return this.fields;
    }

    public Set<InjectionParameterDefinition> getConstructorParams() {
        return this.constructorParams;
    }

    public List<? extends AnnotationMirror> getAnnotationMirrors() {
        return MoreTypes.asTypeElement(this.type).getAnnotationMirrors();
    }

    public Set<BeanDefinition> getSubclasses() {
        return this.subclasses;
    }

    public Set<MethodDefinition> getMethods() {
        return this.methods;
    }

    public Set<BeanDefinition> getDependencies() {
        return this.dependencies;
    }

    public Optional<IOCGenerator<BeanDefinition>> getIocGenerator() {
        return this.iocGenerator;
    }

    public void setIocGenerator(IOCGenerator<BeanDefinition> iocGenerator) {
        this.iocGenerator = Optional.of(iocGenerator);
    }

    public boolean isProxy() {
        return MoreTypes.asTypeElement(this.type).getAnnotation(CircularDependency.class) != null;
    }

    public int hashCode() {
        return Objects.hash(MoreTypes.asTypeElement(this.type).getQualifiedName().toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeanDefinition that = (BeanDefinition)o;
        return MoreTypes.asTypeElement(this.type).getQualifiedName().toString().equals(MoreTypes.asTypeElement(that.type).getQualifiedName().toString());
    }

    public String getPackageName() {
        return Utils.getPackageName(MoreTypes.asTypeElement(this.type));
    }

    public String getQualifiedName() {
        return MoreTypes.asTypeElement(this.type).getQualifiedName().toString();
    }

    public Set<IOCGenerator<BeanDefinition>> getDecorators() {
        return this.decorators;
    }

    public Annotation getScope() {
        if (MoreTypes.asTypeElement(this.type).getAnnotation(Singleton.class) != null) {
            return MoreTypes.asTypeElement(this.type).getAnnotation(Singleton.class);
        }
        if (MoreTypes.asTypeElement(this.type).getAnnotation(ApplicationScoped.class) != null) {
            return MoreTypes.asTypeElement(this.type).getAnnotation(ApplicationScoped.class);
        }
        return new Dependent(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Dependent.class;
            }
        };
    }

    public boolean hasFactory() {
        return this.hasFactory;
    }

    public void setHasFactory(boolean hasFactory) {
        this.hasFactory = hasFactory;
    }
}

